/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.place;

import android.content.Context;
import com.transsion.apiinvoke.invoke.ApiRequest;
import com.transsion.apiinvoke.invoke.ApiResponse;
import com.transsion.kolun.place.AIEngineLog;
import com.transsion.kolun.place.Experience;
import com.transsion.kolun.place.Location;
import com.transsion.kolun.place.Place;
import com.transsion.kolun.place.Stay;
import com.transsion.kolun.place.StayOption;
import com.transsion.kolun.place.Travel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.json.JSONException;
import org.json.JSONObject;

public class ImportPlaceManager {
    private static final String TAG = "ImportPlaceManager";
    private ImportPlaceProxy mProxy;
    private String mPackageName;
    private Context mContext;

    public ImportPlaceManager(Context context) {
        this.mPackageName = context.getPackageName();
        this.mProxy = new ImportPlaceProxy();
        this.mContext = context;
    }

    public Place getPlace(double lat, double lon, long distance) {
        return this.mProxy.getPlaceByLatLon(lat, lon, distance);
    }

    public Place getPlaceById(long placeId) {
        return this.mProxy.getPlaceById(placeId);
    }

    public Stay getStayById(long stayId) {
        return this.mProxy.getStayById(stayId);
    }

    public Experience getExperience(long timestamp) {
        return this.mProxy.getExperienceByTime(timestamp);
    }

    public List<Experience> getExperienceList(long startTime, long endTime) {
        return this.mProxy.getExperienceList(startTime, endTime);
    }

    public List<Place> getPlaceList() {
        try {
            ApiResponse response = new ApiRequest.Builder().channel("AiEngine").apiName("KolunPlaceApi").apiMethod("getPlaceList").build().invoke();
            List placeInfoList = (List)response.content();
            AIEngineLog.d(TAG, "getPlaceList " + placeInfoList.size());
            ArrayList<Place> placeList = new ArrayList<Place>();
            for (String placeInfo : placeInfoList) {
                JSONObject jsonObject = new JSONObject(placeInfo);
                Place place = new Place(jsonObject);
                place.setProxy(this.mProxy);
                placeList.add(place);
            }
            return placeList;
        }
        catch (JSONException e) {
            AIEngineLog.d(TAG, "getPlaceList EXCEPTION " + (Object)((Object)e));
            return new ArrayList<Place>();
        }
    }

    public List<Stay> getStayList(StayOption option) {
        if (option == null) {
            return null;
        }
        String params = option.toExpr();
        ArrayList<Stay> stayList = new ArrayList<Stay>();
        try {
            ApiResponse response = new ApiRequest.Builder().channel("AiEngine").apiName("KolunPlaceApi").apiMethod("getStayList").addParameter((Object)params).build().invoke();
            List stayInfoList = (List)response.content();
            AIEngineLog.d(TAG, "stayInfoList " + stayInfoList);
            if (stayInfoList == null) {
                return new ArrayList<Stay>();
            }
            for (String stayInfo : stayInfoList) {
                Stay stay = Stay.of(stayInfo);
                stayList.add(stay);
            }
        }
        catch (JSONException e) {
            AIEngineLog.d(TAG, "getStayList exception " + (Object)((Object)e));
        }
        return stayList;
    }

    public List<Location> getLocationList(long start, long end) {
        return this.mProxy.getLocationList(start, end);
    }

    class ImportPlaceProxy {
        private Map<Long, Place> mPlaces = new HashMap<Long, Place>();
        private Map<Long, Stay> mStays = new HashMap<Long, Stay>();
        private Map<Long, Travel> mTravels = new HashMap<Long, Travel>();
        private TreeMap<Long, Location> mLocations = new TreeMap();

        ImportPlaceProxy() {
        }

        public Place getPlaceById(long placeId) {
            if (this.mPlaces.containsKey(placeId)) {
                return this.mPlaces.get(placeId);
            }
            Place place = null;
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", (Object)"byId");
                jsonObject.put("id", placeId);
                ApiResponse response = new ApiRequest.Builder().channel("AiEngine").apiName("KolunPlaceApi").apiMethod("getPlace").addParameter((Object)jsonObject.toString()).build().invoke();
                place = Place.of((String)response.content());
            }
            catch (JSONException e) {
                AIEngineLog.d(ImportPlaceManager.TAG, "getPlaceById exception " + (Object)((Object)e));
            }
            if (place != null) {
                this.addPlace(placeId, place);
            }
            return place;
        }

        public Place getPlaceByLatLon(double lat, double lon, long distance) {
            Place place = null;
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", (Object)"byLatLon");
                jsonObject.put("lat", lat);
                jsonObject.put("lon", lon);
                jsonObject.put("distance", distance);
                ApiResponse response = new ApiRequest.Builder().channel("AiEngine").apiName("KolunPlaceApi").apiMethod("getPlace").addParameter((Object)jsonObject.toString()).build().invoke();
                place = Place.of((String)response.content());
            }
            catch (JSONException e) {
                AIEngineLog.d(ImportPlaceManager.TAG, "getPlaceByLatLon exception " + (Object)((Object)e));
            }
            if (place != null) {
                this.addPlace(place.getId(), place);
            }
            return place;
        }

        private void addPlace(long placeId, Place place) {
            this.mPlaces.put(placeId, place);
            place.setProxy(this);
        }

        private void addStay(long stayId, Stay stay) {
            this.mStays.put(stayId, stay);
            stay.setProxy(this);
        }

        private void addTravel(long travelId, Travel travel) {
            this.mTravels.put(travelId, travel);
            travel.setProxy(this);
        }

        public Stay getStayById(long stayId) {
            if (this.mStays.containsKey(stayId)) {
                return this.mStays.get(stayId);
            }
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", (Object)"byId");
                jsonObject.put("id", stayId);
                ApiResponse response = new ApiRequest.Builder().channel("AiEngine").apiName("KolunPlaceApi").apiMethod("getStay").addParameter((Object)jsonObject.toString()).build().invoke();
                String stayInfo = (String)response.content();
                Stay stay = Stay.of(stayInfo);
                this.addStay(stayId, stay);
                return stay;
            }
            catch (JSONException e) {
                AIEngineLog.d(ImportPlaceManager.TAG, "getStayById exception " + (Object)((Object)e));
                return null;
            }
        }

        public Travel getTravelById(long travelId) {
            if (this.mTravels.containsKey(travelId)) {
                return this.mTravels.get(travelId);
            }
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", (Object)"byId");
                jsonObject.put("id", travelId);
                ApiResponse response = new ApiRequest.Builder().channel("AiEngine").apiName("KolunPlaceApi").apiMethod("getTravel").addParameter((Object)jsonObject.toString()).build().invoke();
                Travel travel = Travel.of((String)response.content());
                this.addTravel(travelId, travel);
                return travel;
            }
            catch (JSONException e) {
                AIEngineLog.d(ImportPlaceManager.TAG, "getTravelById exception " + (Object)((Object)e));
                return null;
            }
        }

        public Experience getExperienceByTime(long timestamp) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", (Object)"byTime");
                jsonObject.put("timestamp", timestamp);
                ApiResponse response = new ApiRequest.Builder().channel("AiEngine").apiName("KolunPlaceApi").apiMethod("getExperience").addParameter((Object)jsonObject.toString()).build().invoke();
                String experienceInfo = (String)response.content();
                if (experienceInfo == null) {
                    return null;
                }
                Experience experience = Experience.of(experienceInfo);
                if (experience != null) {
                    experience.setProxy(this);
                }
                return experience;
            }
            catch (JSONException e) {
                AIEngineLog.d(ImportPlaceManager.TAG, "getExperienceByTime exception " + (Object)((Object)e));
                return null;
            }
        }

        public List<Experience> getExperienceList(long startTime, long endTime) {
            ArrayList<Experience> list = new ArrayList<Experience>();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", (Object)"byTime");
                jsonObject.put("startTime", startTime);
                jsonObject.put("endTime", endTime);
                ApiResponse response = new ApiRequest.Builder().channel("AiEngine").apiName("KolunPlaceApi").apiMethod("getExperienceList").addParameter((Object)jsonObject.toString()).build().invoke();
                List experienceList = (List)response.content();
                if (experienceList == null) {
                    return null;
                }
                for (String info : experienceList) {
                    AIEngineLog.d(ImportPlaceManager.TAG, "EXPERIENCE INFO " + info);
                    Experience experience = Experience.of(info);
                    if (experience == null) continue;
                    experience.setProxy(this);
                    list.add(experience);
                }
                return list;
            }
            catch (JSONException e) {
                AIEngineLog.d(ImportPlaceManager.TAG, "getExperienceList exception " + (Object)((Object)e));
                return list;
            }
        }

        public List<Location> getLocationList(long startTime, long endTime) {
            SortedMap<Long, Location> subMap;
            if (this.mLocations.ceilingKey(startTime) != null && this.mLocations.higherKey(endTime) != null && !(subMap = this.mLocations.subMap(startTime, endTime + 1L)).isEmpty()) {
                return new ArrayList<Location>(subMap.values());
            }
            ArrayList<Location> locations = new ArrayList<Location>();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", (Object)"byTime");
                jsonObject.put("startTime", startTime);
                jsonObject.put("endTime", endTime);
                ApiResponse response = new ApiRequest.Builder().channel("AiEngine").apiName("KolunPlaceApi").apiMethod("getLocationList").addParameter((Object)jsonObject.toString()).build().invoke();
                List locationInfoList = (List)response.content();
                for (String info : locationInfoList) {
                    Location location = Location.of(info);
                    locations.add(location);
                }
            }
            catch (JSONException e) {
                AIEngineLog.d(ImportPlaceManager.TAG, "getLocationList exception " + (Object)((Object)e));
            }
            this.addLocationList(locations);
            return locations;
        }

        private void addLocationList(List<Location> locations) {
            for (Location location : locations) {
                this.mLocations.put(location.getTimestamp(), location);
            }
        }
    }
}

