/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.place;

import android.content.Context;
import android.os.RemoteException;
import com.transsion.kolun.place.AIEngineLog;
import com.transsion.kolun.place.GeoFenceClient;
import com.transsion.kolun.place.ImportPlaceManager;
import com.transsion.kolun.place.PoiClient;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.json.JSONObject;

public class KolunPlace {
    private static final String TAG = "KolunPlace";
    private static final String NOT_SUPPORTED = "this device don't support kolun location ";
    private static final String MODULE_NAME = "KolunPlace";
    private static volatile KolunPlace sInstance;
    private final Context mContext;
    private final CallbackProxy mCallback = new CallbackProxy();
    ImportPlaceManager mManager;

    private KolunPlace(Context context) {
        this.mContext = context.getApplicationContext();
        this.mManager = new ImportPlaceManager(this.mContext);
    }

    public static KolunPlace getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new KolunPlace(context);
        }
        return sInstance;
    }

    ImportPlaceManager getImportPlaceManager() {
        return this.mManager;
    }

    public List<String> debugInner(List<String> params) {
        AIEngineLog.d("KolunPlace", "debugInner ");
        return null;
    }

    public boolean register(ArrivalListener listener) {
        boolean flag = this.mCallback.register(listener);
        if (!this.mCallback.isRegister || flag) {
            return this.register();
        }
        return true;
    }

    public boolean unregister(ArrivalListener listener) {
        boolean flag = this.mCallback.unregister(listener);
        if (this.mCallback.isEmpty() && flag) {
            return this.unregister();
        }
        return true;
    }

    public boolean register(DepartureListener listener) {
        boolean flag = this.mCallback.register(listener);
        if (!this.mCallback.isRegister || flag) {
            return this.register();
        }
        return true;
    }

    public boolean unregister(DepartureListener listener) {
        boolean flag = this.mCallback.unregister(listener);
        if (this.mCallback.isEmpty() && flag) {
            return this.unregister();
        }
        return true;
    }

    private boolean register() {
        return false;
    }

    private boolean unregister() {
        return false;
    }

    public boolean register(GeoFenceClient client) {
        return false;
    }

    public boolean unregister(GeoFenceClient client) {
        return false;
    }

    public PoiClient.PoiInfo getPoiInfo(PoiClient.PoiOptions options) {
        String arguments = options.toString();
        return null;
    }

    public JSONObject getLatestLocation() {
        return null;
    }

    static class CallbackProxy {
        private boolean isRegister = false;
        private Collection<ArrivalListener> arrivalListeners = new HashSet<ArrivalListener>();
        private Collection<DepartureListener> departureListeners = new HashSet<DepartureListener>();

        CallbackProxy() {
        }

        public boolean register(ArrivalListener listener) {
            return this.arrivalListeners.add(listener);
        }

        public boolean unregister(ArrivalListener listener) {
            return this.arrivalListeners.remove(listener);
        }

        public boolean register(DepartureListener listener) {
            return this.departureListeners.add(listener);
        }

        public boolean unregister(DepartureListener listener) {
            return this.departureListeners.remove(listener);
        }

        public boolean isEmpty() {
            return this.arrivalListeners.isEmpty() && this.departureListeners.isEmpty();
        }

        public void onArrivalDetected(long from, double lat, double lon) throws RemoteException {
            this.arrivalListeners.forEach(it -> it.onArrivalDetected(from, lat, lon));
        }

        public void onDepartureDetected(long at, double lat, double lon) throws RemoteException {
            this.departureListeners.forEach(it -> it.onDepartureDetected(at, lat, lon));
        }
    }

    public static interface DepartureListener {
        public void onDepartureDetected(long var1, double var3, double var5);
    }

    public static interface ArrivalListener {
        public void onArrivalDetected(long var1, double var3, double var5);
    }
}

