/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.place;

import android.os.Parcel;
import android.os.Parcelable;
import com.transsion.kolun.place.AIEngineLog;

public class LatLon
implements Parcelable {
    private static final String TAG = "LatLon-place";
    public final double mLat;
    public final double mLon;
    public static final Parcelable.Creator<LatLon> CREATOR = new Parcelable.Creator<LatLon>(){

        public LatLon createFromParcel(Parcel in) {
            return new LatLon(in);
        }

        public LatLon[] newArray(int size) {
            return new LatLon[size];
        }
    };

    public LatLon(double lat, double lon) {
        this.mLat = lat;
        this.mLon = lon;
    }

    public static LatLon of(double lat, double lon) {
        return new LatLon(lat, lon);
    }

    public static LatLon of(LatLon latLon) {
        return new LatLon(latLon.mLat, latLon.mLon);
    }

    protected LatLon(Parcel in) {
        this.mLat = in.readDouble();
        this.mLon = in.readDouble();
    }

    public static LatLon of(String latlon) {
        if (latlon == null || latlon.isEmpty()) {
            return null;
        }
        try {
            String[] items = latlon.split(",");
            double lat = Double.parseDouble(items[0].trim());
            double lon = Double.parseDouble(items[1].trim());
            return LatLon.of(lat, lon);
        }
        catch (Exception e) {
            AIEngineLog.d(TAG, " lat of e " + e);
            return null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.mLat);
        dest.writeDouble(this.mLon);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mLat).append(", ").append(this.mLon);
        return sb.toString();
    }
}

