/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.place;

import com.transsion.kolun.place.LatLon;
import org.json.JSONException;
import org.json.JSONObject;

public class Location {
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String LAT = "LAT";
    public static final String LON = "LON";
    private final long mTimestamp;
    private final double mLat;
    private final double mLon;
    private final JSONObject mJson;

    public Location(JSONObject jsonObject) throws JSONException {
        this.mTimestamp = jsonObject.getLong(TIMESTAMP);
        this.mLat = jsonObject.getDouble(LAT);
        this.mLon = jsonObject.getDouble(LON);
        this.mJson = jsonObject;
    }

    public static Location of(String info) throws JSONException {
        JSONObject jsonObject = new JSONObject(info);
        return new Location(jsonObject);
    }

    public Location(long timeStamp, double lat, double lon) {
        this.mTimestamp = timeStamp;
        this.mLat = lat;
        this.mLon = lon;
        this.mJson = null;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public double getLat() {
        return this.mLat;
    }

    public double getLon() {
        return this.mLon;
    }

    public LatLon getLatLon() {
        return LatLon.of(this.mLat, this.mLon);
    }

    public String toExpression() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mLat).append(", ").append(this.mLon);
        return sb.toString();
    }
}

