/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.place;

import com.transsion.kolun.place.ImportPlaceManager;
import com.transsion.kolun.place.LatLon;
import com.transsion.kolun.place.Stay;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Place
implements Iterable<Stay> {
    public final long mPlaceId;
    public final LatLon mCenterPoint;
    public final String mSemantic;
    private final List<Long> mStayList;
    public static final String PLACE_ID = "PLACE_ID";
    public static final String LAT = "LAT";
    public static final String LON = "LON";
    public static final String SEMANTIC = "SEMANTIC";
    public static final String STAY_LIST = "STAY_LIST";
    public static final String SEMANTIC_HOME = "home_place";
    public static final String SEMANTIC_WORK = "work_place";
    public ImportPlaceManager.ImportPlaceProxy mProxy;

    public void setProxy(ImportPlaceManager.ImportPlaceProxy manager) {
        this.mProxy = manager;
    }

    public static Place of(String info) throws JSONException {
        if (info == null || info.isEmpty()) {
            return null;
        }
        JSONObject jsonObject = new JSONObject(info);
        return new Place(jsonObject);
    }

    public Place(JSONObject jsonObject) throws JSONException {
        this.mPlaceId = jsonObject.getLong(PLACE_ID);
        double lat = jsonObject.getDouble(LAT);
        double lon = jsonObject.getDouble(LON);
        this.mCenterPoint = LatLon.of(lat, lon);
        JSONArray jsonArray = jsonObject.getJSONArray(STAY_LIST);
        int length = jsonArray.length();
        this.mStayList = new ArrayList<Long>();
        for (int i = 0; i < length; ++i) {
            this.mStayList.add(jsonArray.getLong(i));
        }
        this.mSemantic = jsonObject.getString(SEMANTIC);
    }

    public Place(long id, LatLon center, String mSemantic, List<Long> stayList) {
        this.mPlaceId = id;
        this.mCenterPoint = center;
        this.mSemantic = mSemantic;
        this.mStayList = stayList;
    }

    public long getId() {
        return this.mPlaceId;
    }

    public LatLon getLatLon() {
        return this.mCenterPoint;
    }

    public int size() {
        return this.mStayList.size();
    }

    @Override
    public Iterator<Stay> iterator() {
        return new StayIterator();
    }

    public Stay getStay(long stayId) {
        return this.mProxy.getStayById(stayId);
    }

    public List<Stay> getStayList() {
        return this.mStayList.stream().map(stayId -> this.mProxy.getStayById((long)stayId)).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("placeId ").append(this.mPlaceId);
        sb.append("size ").append(this.size());
        for (Stay stay : this) {
            sb.append("stay ").append(stay).append("\t");
        }
        return sb.toString();
    }

    public String toExpression() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLatLon());
        sb.append("\u505c\u7559\u6b21\u6570 ").append(this.size());
        return sb.toString();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(PLACE_ID, this.mPlaceId);
        jsonObject.put(LAT, this.mCenterPoint.mLat);
        jsonObject.put(LON, this.mCenterPoint.mLon);
        jsonObject.put(STAY_LIST, (Object)new JSONArray(this.mStayList));
        return jsonObject;
    }

    class StayIterator
    implements Iterator<Stay> {
        Iterator<Long> mIdIterator;

        StayIterator() {
            this.mIdIterator = Place.this.mStayList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.mIdIterator.hasNext();
        }

        @Override
        public Stay next() {
            if (Place.this.mProxy != null) {
                return Place.this.mProxy.getStayById(this.mIdIterator.next());
            }
            return null;
        }
    }
}

