/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.place;

import com.transsion.kolun.place.AIEngineLog;
import org.json.JSONException;
import org.json.JSONObject;

public class PoiClient {
    public static final String TAG = "PoiClient";
    public static final String POI_TYPE = "poi_type";
    public static final String PRECISION = "precision";

    public static PoiInfo ofInfo(String info) throws JSONException {
        if (info == null) {
            info = "";
        }
        JSONObject jsonObject = new JSONObject(info);
        PoiInfo poiInfo = new PoiInfo(jsonObject);
        return poiInfo;
    }

    public static PoiOptions ofOption(String type, double p) {
        return new PoiOptions(type, p);
    }

    public static class PoiOptions {
        String poiType;
        double precision;

        PoiOptions(String type, double p) {
            this.poiType = type;
            this.precision = p;
        }

        public String toString() {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put(PoiClient.POI_TYPE, (Object)this.poiType);
                jsonObject.put(PoiClient.PRECISION, this.precision);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return jsonObject.toString();
        }
    }

    public static class PoiInfo {
        String name;
        String poiType;
        JSONObject jsonObject;

        PoiInfo(JSONObject object) {
            this.jsonObject = object;
        }

        public String toString() {
            return this.jsonObject.toString();
        }

        public long getTime() {
            if (this.jsonObject.has("time")) {
                try {
                    return this.jsonObject.getLong("time");
                }
                catch (JSONException e) {
                    AIEngineLog.d(PoiClient.TAG, "isHome " + (Object)((Object)e));
                    return -1L;
                }
            }
            return -1L;
        }

        public boolean isHome() {
            if (this.jsonObject.has("home")) {
                try {
                    return this.jsonObject.getBoolean("home");
                }
                catch (JSONException e) {
                    AIEngineLog.d(PoiClient.TAG, "isHome " + (Object)((Object)e));
                    return false;
                }
            }
            return false;
        }

        public JSONObject getJsonObject() {
            return this.jsonObject;
        }
    }
}

