/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.place;

import com.transsion.kolun.place.Experience;
import com.transsion.kolun.place.LatLon;
import com.transsion.kolun.place.Place;
import org.json.JSONException;
import org.json.JSONObject;

public class Stay
extends Experience {
    public static final String PLACE_ID = "PLACE_ID";
    public static final String STAY_ID = "STAY_ID";
    public static final String LAT = "LAT";
    public static final String LON = "LON";
    public final long mPlaceId;
    public final long mStayId;
    public final LatLon mCenterPoint;

    public static Stay of(String stayInfo) throws JSONException {
        if (stayInfo == null || stayInfo.isEmpty()) {
            return null;
        }
        JSONObject jsonObject = new JSONObject(stayInfo);
        return new Stay(jsonObject);
    }

    public long getPlaceId() {
        return this.mPlaceId;
    }

    public long getStayId() {
        return this.mStayId;
    }

    protected Stay(JSONObject jsonObject) throws JSONException {
        super(jsonObject);
        this.mPlaceId = jsonObject.getLong(PLACE_ID);
        this.mStayId = jsonObject.getLong(STAY_ID);
        double lat = jsonObject.getDouble(LAT);
        double lon = jsonObject.getDouble(LON);
        this.mCenterPoint = LatLon.of(lat, lon);
    }

    public Stay(long start, long end, long placeId, long stayId, double lat, double lon) {
        super(start, end);
        this.mPlaceId = placeId;
        this.mStayId = stayId;
        this.mCenterPoint = LatLon.of(lat, lon);
    }

    public LatLon getLatLon() {
        return this.mCenterPoint;
    }

    public Place getPlace() {
        return this.mProxy.getPlaceById(this.mPlaceId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("type: ").append("Stay ");
        sb.append(super.toString());
        sb.append(" stayId ").append(this.getStayId());
        sb.append(" placeId ").append(this.getPlaceId());
        sb.append(" center ").append(this.getLatLon());
        return sb.toString();
    }

    @Override
    public long getId() {
        return this.getStayId();
    }
}

