/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.place;

import com.transsion.kolun.place.AIEngineLog;
import org.json.JSONException;
import org.json.JSONObject;

public class StayOption {
    public static final String TAG = "StayOptionA";
    private double mLat;
    private double mLon;
    private double mDistance;
    private long mStartTime;
    private long mEndTime;

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("lat", this.mLat);
            jsonObject.put("lon", this.mLon);
            jsonObject.put("distance", this.mDistance);
            jsonObject.put("start_time", this.mStartTime);
            jsonObject.put("end_time", this.mEndTime);
            return jsonObject;
        }
        catch (JSONException e) {
            AIEngineLog.d(TAG, "toJSon " + (Object)((Object)e));
            return null;
        }
    }

    public String toExpr() {
        JSONObject jsonObject = this.toJson();
        if (jsonObject != null) {
            return jsonObject.toString();
        }
        return "";
    }

    private StayOption(double lat, double lon) {
        this.mLat = lat;
        this.mLon = lon;
    }

    public static class Builder {
        private double lat;
        private double lon;
        private long distance;
        private long startTime;
        private long endTime;

        public Builder(double lat, double lon) {
            this.lat = lat;
            this.lon = lon;
        }

        public Builder setDistance(long distance) {
            this.distance = distance;
            return this;
        }

        public Builder setStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder setEndTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public StayOption build() {
            StayOption option = new StayOption(this.lat, this.lon);
            option.mDistance = this.distance;
            option.mStartTime = this.startTime;
            option.mEndTime = this.endTime;
            return option;
        }
    }
}

