/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.place;

import com.transsion.kolun.place.Experience;
import com.transsion.kolun.place.LatLon;
import com.transsion.kolun.place.Place;
import com.transsion.kolun.place.Stay;
import org.json.JSONException;
import org.json.JSONObject;

public class Travel
extends Experience {
    public static final String PRE_STAY_ID = "PRE_STAY_ID";
    public static final String POST_STAY_ID = "POST_STAY_ID";
    public static final String TRAVEL_ID = "TRAVEL_ID";
    public static final String START_LAT_LON = "START_LAT_LON";
    public static final String END_LAT_LON = "END_LAT_LON";
    private final long mPreStayId;
    private final long mPostStayId;
    LatLon mStart;
    LatLon mEnd;
    private final long mTravelId;

    public LatLon getStartPoint() {
        return this.mStart;
    }

    public LatLon getEndPoint() {
        return this.mEnd;
    }

    public static Travel of(String travelInfo) throws JSONException {
        if (travelInfo == null || travelInfo.isEmpty()) {
            return null;
        }
        JSONObject jsonObject = new JSONObject(travelInfo);
        return new Travel(jsonObject);
    }

    protected Travel(JSONObject jsonObject) throws JSONException {
        super(jsonObject);
        this.mTravelId = jsonObject.getLong(TRAVEL_ID);
        this.mPreStayId = jsonObject.getLong(PRE_STAY_ID);
        this.mPostStayId = jsonObject.getLong(POST_STAY_ID);
        if (jsonObject.has(START_LAT_LON)) {
            String startLatLon = jsonObject.getString(START_LAT_LON);
            this.mStart = LatLon.of(startLatLon);
        }
        if (jsonObject.has(END_LAT_LON)) {
            String endLatLon = jsonObject.getString(END_LAT_LON);
            this.mEnd = LatLon.of(endLatLon);
        }
    }

    public long getTravelId() {
        return this.mTravelId;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("type: ").append("Travel ");
        sb.append(super.toString());
        sb.append(" travelId ").append(this.getTravelId());
        sb.append(" startLatLon ").append(this.mStart);
        sb.append(" endLatLon ").append(this.mEnd);
        sb.append(" mPreStayId ").append(this.mPreStayId);
        sb.append(" mPostStayId ").append(this.mPostStayId);
        return sb.toString();
    }

    @Override
    public long getId() {
        return this.mTravelId;
    }

    public Stay getPre() {
        return this.mProxy.getStayById(this.mPreStayId);
    }

    public Stay getPost() {
        return this.mProxy.getStayById(this.mPostStayId);
    }

    public Place getPrePlace() {
        Stay preStay = this.getPre();
        if (preStay != null) {
            return preStay.getPlace();
        }
        return null;
    }

    public Place getPostPlace() {
        Stay postStay = this.getPost();
        if (postStay != null) {
            return postStay.getPlace();
        }
        return null;
    }
}

