/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.apiinvoke.ipc;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.transsion.apiinvoke.ipc.ICommonServiceInterface;

public interface IRemoteAPIConnection
extends IInterface {
    public void onConnected(Bundle var1, ICommonServiceInterface var2) throws RemoteException;

    public void onDisconnected(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRemoteAPIConnection {
        private static final String DESCRIPTOR = "com.transsion.apiinvoke.ipc.IRemoteAPIConnection";
        static final int TRANSACTION_onConnected = 1;
        static final int TRANSACTION_onDisconnected = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IRemoteAPIConnection asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IRemoteAPIConnection) {
                return (IRemoteAPIConnection)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    Bundle _arg0 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    ICommonServiceInterface _arg1 = ICommonServiceInterface.Stub.asInterface(data.readStrongBinder());
                    this.onConnected(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.onDisconnected(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IRemoteAPIConnection impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IRemoteAPIConnection getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IRemoteAPIConnection {
            private IBinder mRemote;
            public static IRemoteAPIConnection sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnected(Bundle bundle, ICommonServiceInterface serviceInterface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bundle != null) {
                        _data.writeInt(1);
                        bundle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(serviceInterface != null ? serviceInterface.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onConnected(bundle, serviceInterface);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisconnected(String channelName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(channelName);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDisconnected(channelName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRemoteAPIConnection {
        @Override
        public void onConnected(Bundle bundle, ICommonServiceInterface serviceInterface) throws RemoteException {
        }

        @Override
        public void onDisconnected(String channelName) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

