/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.apiinvoke.ipc;

import android.os.RemoteException;
import com.transsion.apiinvoke.invoke.api.ApiPublisher;
import com.transsion.apiinvoke.ipc.APIPublisher;
import com.transsion.apiinvoke.ipc.ParcelPublishData;
import com.transsion.apiinvoke.ipc.ParcelPublisher;
import com.transsion.apiinvoke.ipc.SubscribeStateChangeObserver;
import com.transsion.apiinvoke.subscribe.PublishData;
import com.transsion.apiinvoke.subscribe.Publisher;
import com.transsion.apiinvoke.subscribe.SubscribeHostInfo;
import com.transsion.apiinvoke.subscribe.SubscribeManager;
import java.io.Serializable;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteApiPublisherStub
extends APIPublisher.Stub
implements ApiPublisher {
    private SubscribeStateChangeObserver mStateChangeObserver = new SubscribeStateChangeObserver.Stub(){

        @Override
        public void onSubscribeChange(ParcelPublisher parcelPublisher, int subscribeCount) {
            Publisher publisher = parcelPublisher.getPublisher();
            SubscribeManager.getInstance((Publisher.Host)publisher.host).onSubscribeCountChange(publisher, subscribeCount);
        }
    };

    @Override
    public SubscribeStateChangeObserver getSubscribeStateChangeObserver() {
        return this.mStateChangeObserver;
    }

    @Override
    public void onPublishData(ParcelPublishData publishData) {
        if (publishData == null) {
            return;
        }
        try {
            PublishData data = publishData.getPublishData();
            this.publishData(data.getPublisher(), data.getData());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String[] getLocalSubscribeTypes() {
        List subscribeHost = SubscribeManager.getAllSubscribeHostInfo();
        String[] infos = new String[subscribeHost.size()];
        for (int i = 0; i < subscribeHost.size(); ++i) {
            infos[i] = this.parseSubscribeHostInfo((SubscribeHostInfo)subscribeHost.get(i));
        }
        return infos;
    }

    @Override
    public int findLocalSubscribeTypeCount(String process, String subscribe, String matcher) throws RemoteException {
        SubscribeManager manager = SubscribeManager.getInstance((String)process, (String)subscribe);
        if (manager == null) {
            return 0;
        }
        try {
            return manager.countLocalSubscribe(matcher);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public void publishData(Publisher publisher, Serializable data) {
        try {
            SubscribeManager.getInstance((Publisher.Host)publisher.host).publishData(publisher, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String parseSubscribeHostInfo(SubscribeHostInfo info) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("host", (Object)info.getHost().toString());
            List typeCounts = info.getSubscribeTypes();
            JSONArray jsonArray = new JSONArray();
            for (SubscribeHostInfo.SubscribeTypeCount typeCount : typeCounts) {
                JSONObject objectItem = new JSONObject();
                objectItem.put("type", (Object)typeCount.type);
                objectItem.put("subscribeCount", typeCount.subscribeCount);
                jsonArray.put((Object)objectItem);
            }
            jsonObject.put("typeCounts", (Object)jsonArray);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }
}

