/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.apiinvoke.ipc.typeparcel;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.transsion.apiinvoke.invoke.TypeValuePair;
import com.transsion.apiinvoke.ipc.ITypeParcel;
import com.transsion.apiinvoke.ipc.TypeParcelFactor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeValuePairTypeParcel
implements ITypeParcel<TypeValuePair> {
    @Override
    public TypeValuePair readFormParcel(Parcel parcel, Class type) {
        if (parcel.readInt() == 0) {
            return TypeValuePair.empty();
        }
        String name = parcel.readString();
        int length = parcel.readInt();
        if (length == 0) {
            Class valueType = (Class)parcel.readSerializable();
            Object value = TypeParcelFactor.getFactor().readFormParcel(parcel, valueType);
            return TypeValuePair.create((Class)valueType, (Object)value, (String)name);
        }
        type = (Class)parcel.readSerializable();
        Object[] objects = new Object[length];
        for (int i = 0; i < length; ++i) {
            Class clazzType = (Class)parcel.readSerializable();
            objects[i] = TypeParcelFactor.getFactor().readFormParcel(parcel, clazzType);
        }
        return TypeValuePair.create((Class)type, (Object)objects, (String)name);
    }

    @Override
    public void writeToParcel(Parcel in, Class type, TypeValuePair value, int flags) {
        if (type == null) {
            in.writeInt(0);
            return;
        }
        Class originType = value.getValueType();
        Object originValue = value.getValue();
        if (originValue == null) {
            in.writeInt(0);
            return;
        }
        if (originType == null) {
            originType = TypeValuePairTypeParcel.mappingClass(originValue.getClass(), originValue);
        }
        if (originType == null) {
            in.writeInt(0);
            return;
        }
        in.writeInt(1);
        in.writeString(value.getName());
        if (!originType.isArray()) {
            in.writeInt(0);
            Class typeMapping = TypeValuePairTypeParcel.mappingClass(originType, value.getValue());
            in.writeSerializable((Serializable)typeMapping);
            TypeParcelFactor.getFactor().writeToParcel(in, typeMapping, originValue, flags);
        } else {
            int length = Array.getLength(originValue);
            in.writeInt(length);
            in.writeSerializable((Serializable)originType);
            for (int i = 0; i < length; ++i) {
                Object itemValue = Array.get(originValue, i);
                Class typeMapping = TypeValuePairTypeParcel.mappingClass(itemValue.getClass(), itemValue);
                in.writeSerializable((Serializable)typeMapping);
                TypeParcelFactor.getFactor().writeToParcel(in, typeMapping, itemValue, flags);
            }
        }
    }

    private static Class mappingClass(Class clazz, Object value) {
        if (!clazz.equals(Object.class)) {
            return clazz;
        }
        if (value instanceof Short) {
            return Short.TYPE;
        }
        if (value instanceof Integer) {
            return Integer.TYPE;
        }
        if (value instanceof Float) {
            return Float.TYPE;
        }
        if (value instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (value instanceof String) {
            return String.class;
        }
        if (value instanceof Byte) {
            return Byte.TYPE;
        }
        if (value instanceof Double) {
            return Double.TYPE;
        }
        if (value instanceof List) {
            return List.class;
        }
        if (value instanceof Map) {
            return Map.class;
        }
        if (value instanceof Set) {
            return Set.class;
        }
        if (value instanceof Bundle) {
            return Bundle.class;
        }
        if (value instanceof Parcelable) {
            return Parcelable.class;
        }
        if (value instanceof Serializable) {
            return Serializable.class;
        }
        return clazz;
    }
}

