/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.common.eventbus;

import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import com.transsion.kolun.common.eventbus.EventHandler;
import com.transsion.kolun.common.eventbus.EventHandlerMethod;
import com.transsion.kolun.common.eventbus.Subscriber;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class EventBus {
    private static final String TAG = "EventBus";
    private static final boolean DEBUG_EVENT_BUS = false;
    private static final boolean DEBUG_EVENT_BUS_TRACE = false;
    private static final String METHOD_PREFIX = "onBusEvent";
    private static final int DEFAULT_SUBSCRIBER_PRIORITY = 1;
    private static final Comparator<EventHandler> EVENT_HANDLER_COMPARATOR = new Comparator<EventHandler>(){

        @Override
        public int compare(EventHandler h1, EventHandler h2) {
            if (h1.priority != h2.priority) {
                return h2.priority - h1.priority;
            }
            return Long.compare(h2.subscriber.registrationTime, h1.subscriber.registrationTime);
        }
    };
    private static final Object sLock = new Object();
    private static volatile EventBus sDefaultBus;
    private final Handler mHandler;
    private final HashMap<Class<? extends Event>, ArrayList<EventHandler>> mEventTypeMap = new HashMap();
    private final HashMap<Class<?>, ArrayList<EventHandlerMethod>> mSubscriberTypeMap = new HashMap();
    private final ArrayList<Subscriber> mSubscribers = new ArrayList();
    private int mCallCount;
    private long mCallDurationMicros;

    private EventBus(Looper looper) {
        this.mHandler = new Handler(looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Looper looper) {
        if (sDefaultBus == null) {
            Object object = sLock;
            synchronized (object) {
                if (sDefaultBus == null) {
                    EventBus.logWithPid("New EventBus " + looper);
                    sDefaultBus = new EventBus(looper);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventBus getDefault() {
        if (sDefaultBus == null) {
            Object object = sLock;
            synchronized (object) {
                if (sDefaultBus == null) {
                    EventBus.logWithPid("New EventBus");
                    sDefaultBus = new EventBus(Looper.getMainLooper());
                }
            }
        }
        return sDefaultBus;
    }

    private static void logWithPid(String text) {
        Log.v((String)TAG, (String)("[" + Process.myPid() + "] " + text));
    }

    public void register(Object subscriber) {
        this.mHandler.post(() -> this.registerSubscriber(subscriber, 1));
    }

    public void register(Object subscriber, int priority) {
        this.mHandler.post(() -> this.registerSubscriber(subscriber, priority));
    }

    public void unregister(Object subscriber) {
        this.mHandler.post(() -> this.unregisterSubscriber(subscriber));
    }

    private void unregisterSubscriber(Object subscriber) {
        long callingThreadId = Thread.currentThread().getId();
        if (callingThreadId != this.mHandler.getLooper().getThread().getId()) {
            throw new RuntimeException("Can not unregister() a subscriber from a outer thread.");
        }
        if (!this.findRegisteredSubscriber(subscriber, true)) {
            return;
        }
        Class<?> subscriberType = subscriber.getClass();
        ArrayList<EventHandlerMethod> subscriberMethods = this.mSubscriberTypeMap.get(subscriberType);
        if (subscriberMethods != null) {
            for (EventHandlerMethod method : subscriberMethods) {
                ArrayList<EventHandler> eventHandlers = this.mEventTypeMap.get(method.eventType);
                for (int i = eventHandlers.size() - 1; i >= 0; --i) {
                    if (eventHandlers.get((int)i).subscriber.getReference() != subscriber) continue;
                    eventHandlers.remove(i);
                }
            }
        }
    }

    public void send(Event event) {
        this.post(event);
    }

    public void post(Event event) {
        event.requiresPost = true;
        event.cancelled = false;
        this.queueEvent(event);
    }

    public void sendOntoMainThread(Event event) {
        long callingThreadId = Thread.currentThread().getId();
        if (callingThreadId != this.mHandler.getLooper().getThread().getId()) {
            this.post(event);
        } else {
            this.send(event);
        }
    }

    public void dump(String prefix, PrintWriter writer) {
        writer.println(this.dumpInternal(prefix));
    }

    public String dumpInternal(String prefix) {
        String innerPrefix = prefix + "  ";
        String innerInnerPrefix = innerPrefix + "  ";
        StringBuilder output = new StringBuilder();
        output.append(prefix);
        output.append("Registered class types:");
        output.append("\n");
        ArrayList subscriberTypes = new ArrayList(this.mSubscriberTypeMap.keySet());
        Collections.sort(subscriberTypes, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        for (int i = 0; i < subscriberTypes.size(); ++i) {
            Class<?> clz = subscriberTypes.get(i);
            output.append(innerPrefix);
            output.append(clz.getSimpleName());
            output.append("\n");
        }
        output.append(prefix);
        output.append("Event map:");
        output.append("\n");
        ArrayList<Class<? extends Event>> classes = new ArrayList<Class<? extends Event>>(this.mEventTypeMap.keySet());
        Collections.sort(classes, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        for (int i = 0; i < classes.size(); ++i) {
            Class<? extends Event> clz = classes.get(i);
            output.append(innerPrefix);
            output.append(clz.getSimpleName());
            output.append(" -> ");
            output.append("\n");
            ArrayList<EventHandler> handlers = this.mEventTypeMap.get(clz);
            for (EventHandler handler : handlers) {
                Object subscriber = handler.subscriber.getReference();
                if (subscriber == null) continue;
                String id = Integer.toHexString(System.identityHashCode(subscriber));
                output.append(innerInnerPrefix);
                output.append(subscriber.getClass().getSimpleName());
                output.append(" [0x" + id + ", #" + handler.priority + "]");
                output.append("\n");
            }
        }
        return output.toString();
    }

    private void registerSubscriber(Object subscriber, int priority) {
        Method[] methods;
        long callingThreadId = Thread.currentThread().getId();
        if (callingThreadId != this.mHandler.getLooper().getThread().getId()) {
            throw new RuntimeException("Can not register() a subscriber from a outer thread.");
        }
        if (this.findRegisteredSubscriber(subscriber, false)) {
            return;
        }
        long t1 = 0L;
        Subscriber sub = new Subscriber(subscriber, SystemClock.uptimeMillis());
        Class<?> subscriberType = subscriber.getClass();
        ArrayList<EventHandlerMethod> subscriberMethods = this.mSubscriberTypeMap.get(subscriberType);
        if (subscriberMethods != null) {
            for (EventHandlerMethod method : subscriberMethods) {
                ArrayList<EventHandler> eventTypeHandlers = this.mEventTypeMap.get(method.eventType);
                eventTypeHandlers.add(new EventHandler(sub, method, priority));
                this.sortEventHandlersByPriority(eventTypeHandlers);
            }
            this.mSubscribers.add(sub);
            return;
        }
        subscriberMethods = new ArrayList();
        this.mSubscriberTypeMap.put(subscriberType, subscriberMethods);
        this.mSubscribers.add(sub);
        for (Method m : methods = subscriberType.getDeclaredMethods()) {
            Class<?>[] parameterTypes = m.getParameterTypes();
            if (!this.isValidEventBusHandlerMethod(m, parameterTypes)) continue;
            Class<?> eventType = parameterTypes[0];
            ArrayList<EventHandler> eventTypeHandlers = this.mEventTypeMap.get(eventType);
            if (eventTypeHandlers == null) {
                eventTypeHandlers = new ArrayList();
                this.mEventTypeMap.put(eventType, eventTypeHandlers);
            }
            EventHandlerMethod method = new EventHandlerMethod(m, eventType);
            EventHandler handler = new EventHandler(sub, method, priority);
            eventTypeHandlers.add(handler);
            subscriberMethods.add(method);
            this.sortEventHandlersByPriority(eventTypeHandlers);
        }
    }

    private void queueEvent(Event event) {
        ArrayList eventHandlers = this.mEventTypeMap.get(event.getClass());
        if (eventHandlers == null) {
            event.onPreDispatch();
            event.onPostDispatch();
            return;
        }
        boolean hasPostedEvent = false;
        event.onPreDispatch();
        eventHandlers = (ArrayList)eventHandlers.clone();
        int eventHandlerCount = eventHandlers.size();
        for (int i = 0; i < eventHandlerCount; ++i) {
            EventHandler eventHandler = (EventHandler)eventHandlers.get(i);
            if (eventHandler.subscriber.getReference() == null) continue;
            if (event.requiresPost) {
                this.mHandler.post(() -> this.processEvent(eventHandler, event));
                hasPostedEvent = true;
                continue;
            }
            this.processEvent(eventHandler, event);
        }
        if (hasPostedEvent) {
            this.mHandler.post(() -> event.onPostDispatch());
        } else {
            event.onPostDispatch();
        }
    }

    private void processEvent(EventHandler eventHandler, Event event) {
        if (event.cancelled) {
            if (event.trace) {
                EventBus.logWithPid("Event dispatch cancelled");
            }
            return;
        }
        try {
            if (event.trace) {
                EventBus.logWithPid(" -> " + eventHandler.toString());
            }
            Object sub = eventHandler.subscriber.getReference();
            if (sub != null) {
                long t1 = 0L;
                eventHandler.method.invoke(sub, event);
            } else {
                Log.e((String)TAG, (String)"Failed to deliver event to null subscriber");
            }
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"Failed to invoke method", (Throwable)e.getCause());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private boolean findRegisteredSubscriber(Object subscriber, boolean removeFoundSubscriber) {
        for (int i = this.mSubscribers.size() - 1; i >= 0; --i) {
            Subscriber sub = this.mSubscribers.get(i);
            if (sub.getReference() != subscriber) continue;
            if (removeFoundSubscriber) {
                this.mSubscribers.remove(i);
            }
            return true;
        }
        return false;
    }

    private boolean isValidEventBusHandlerMethod(Method method, Class<?>[] parameterTypes) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isFinal(modifiers) && method.getReturnType().equals(Void.TYPE) && parameterTypes.length == 1 && Event.class.isAssignableFrom(parameterTypes[0]) && method.getName().startsWith(METHOD_PREFIX);
    }

    private void sortEventHandlersByPriority(List<EventHandler> eventHandlers) {
        Collections.sort(eventHandlers, EVENT_HANDLER_COMPARATOR);
    }

    public static class ReusableEvent
    extends Event {
        private int mDispatchCount;

        protected ReusableEvent() {
        }

        @Override
        void onPostDispatch() {
            super.onPostDispatch();
            ++this.mDispatchCount;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }
    }

    public static class Event
    implements Cloneable {
        boolean trace;
        boolean requiresPost;
        boolean cancelled;

        protected Event() {
        }

        void onPreDispatch() {
        }

        void onPostDispatch() {
        }

        protected Object clone() throws CloneNotSupportedException {
            Event evt = (Event)super.clone();
            evt.cancelled = false;
            return evt;
        }
    }
}

