/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.common;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.os.Build;
import android.text.TextUtils;
import com.transsion.aiservice.common.utils.AiLog;
import java.security.MessageDigest;
import java.util.ArrayList;

public class AppSigning {
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA1";
    public static final String SHA256 = "SHA256";

    public static ArrayList<String> getSignInfo(Context context, String packageName, String type) {
        if (context == null || type == null) {
            return null;
        }
        if (packageName == null) {
            return null;
        }
        ArrayList<String> mList = new ArrayList<String>();
        try {
            Signature[] signs;
            for (Signature sig : signs = AppSigning.getSignatures(context, packageName)) {
                String tmp = "error!";
                if (MD5.equals(type)) {
                    tmp = AppSigning.getSignatureByteString(sig, MD5);
                } else if (SHA1.equals(type)) {
                    tmp = AppSigning.getSignatureByteString(sig, SHA1);
                } else if (SHA256.equals(type)) {
                    tmp = AppSigning.getSignatureByteString(sig, SHA256);
                }
                mList.add(tmp);
            }
        }
        catch (Exception e) {
            AiLog.w("AppSigning", e.toString());
        }
        return mList;
    }

    public static String getSha1(Context context, String packageName) {
        String res = "";
        ArrayList<String> mlist = AppSigning.getSignInfo(context, packageName, SHA1);
        if (mlist != null && mlist.size() != 0) {
            res = mlist.get(0);
        }
        return res;
    }

    public static String getMD5(Context context, String packageName) {
        String res = "";
        ArrayList<String> mlist = AppSigning.getSignInfo(context, packageName, MD5);
        if (mlist != null && mlist.size() != 0) {
            res = mlist.get(0);
        }
        return res;
    }

    public static String getSHA256(Context context, String packageName) {
        String res = "";
        ArrayList<String> mlist = AppSigning.getSignInfo(context, packageName, SHA256);
        if (mlist != null && mlist.size() != 0) {
            res = mlist.get(0);
        }
        return res;
    }

    private static Signature[] getSignatures(Context context, String packageName) {
        PackageInfo packageInfo = null;
        try {
            if (Build.VERSION.SDK_INT >= 28) {
                packageInfo = context.getPackageManager().getPackageInfo(packageName, 0x8000000);
                return packageInfo.signingInfo.getApkContentsSigners();
            }
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 64);
            return packageInfo.signatures;
        }
        catch (Exception e) {
            AiLog.w("AppSigning", e.toString());
            return null;
        }
    }

    private static String getSignatureString(Signature sig, String type) {
        byte[] hexBytes = sig.toByteArray();
        String fingerprint = "error!";
        try {
            MessageDigest digest = MessageDigest.getInstance(type);
            if (digest != null) {
                byte[] digestBytes = digest.digest(hexBytes);
                StringBuilder sb = new StringBuilder();
                for (byte digestByte : digestBytes) {
                    sb.append(Integer.toHexString(digestByte & 0xFF | 0x100).substring(1, 3));
                }
                fingerprint = sb.toString();
            }
        }
        catch (Exception e) {
            AiLog.w("AppSigning", e.toString());
        }
        return fingerprint;
    }

    public static String getSignatureByteString(Signature sig, String type) {
        byte[] hexBytes = sig.toByteArray();
        String fingerprint = "error!";
        try {
            MessageDigest digest = MessageDigest.getInstance(type);
            if (digest != null) {
                byte[] digestBytes = digest.digest(hexBytes);
                StringBuilder sb = new StringBuilder();
                for (byte digestByte : digestBytes) {
                    sb.append(Integer.toHexString(digestByte & 0xFF | 0x100).substring(1, 3).toUpperCase());
                    sb.append(":");
                }
                fingerprint = sb.substring(0, sb.length() - 1);
            }
            if (!TextUtils.isEmpty((CharSequence)fingerprint)) {
                fingerprint = fingerprint.replace(":", "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fingerprint;
    }
}

