/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.common;

import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class IInterfaceProxy<T extends IInterface> {
    private static final String TAG = "IInterfaceProxy";
    private T mHookInterFace;
    private Class<T> interFaceType;
    private T mNullInterFace = null;
    InvocationHandler handler = (proxy, method, args) -> {
        throw new RemoteException("is NUllInterFace " + method.getName());
    };

    public IInterfaceProxy(Class<T> hookInterFace) {
        this.interFaceType = hookInterFace;
    }

    public IInterfaceProxy() {
    }

    public IInterfaceProxy<T> bindInterface(T hookInterFace) {
        if (hookInterFace == null) {
            return this;
        }
        this.mHookInterFace = hookInterFace;
        this.createNullInterFace();
        IBinder iBinder = hookInterFace.asBinder();
        try {
            iBinder.linkToDeath((IBinder.DeathRecipient)new MyDeathRecipient(), 0);
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)("getGoalStep,err:" + (Object)((Object)e)));
        }
        return this;
    }

    private void createNullInterFace() {
        if (this.interFaceType == null) {
            return;
        }
        try {
            this.mNullInterFace = (IInterface)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.interFaceType}, this.handler);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            Log.w((String)TAG, (String)("createNullInterFace,err:" + e));
        }
    }

    public boolean isConnected() {
        return this.mHookInterFace != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getInterface() {
        IInterfaceProxy iInterfaceProxy = this;
        synchronized (iInterfaceProxy) {
            return this.mHookInterFace == null ? this.mNullInterFace : this.mHookInterFace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IInterfaceProxy iInterfaceProxy = this;
        synchronized (iInterfaceProxy) {
            this.mHookInterFace = null;
        }
    }

    private class MyDeathRecipient
    implements IBinder.DeathRecipient {
        private MyDeathRecipient() {
        }

        public void binderDied() {
            IInterfaceProxy.this.remove();
        }
    }
}

