/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.common;

import com.transsion.aiservice.common.Pool;

public class ObjectPool<T>
implements Pool<T> {
    private final ThreadLocal<Object[]> mPool = new ThreadLocal();
    private int mPoolSize;

    public ObjectPool(int maxPoolSize) {
        if (maxPoolSize <= 0) {
            throw new IllegalArgumentException("The max pool size must be > 0");
        }
        Object[] arrays = new Object[maxPoolSize];
        this.mPool.set(arrays);
    }

    @Override
    public T acquire() {
        Object[] arrays = this.mPool.get();
        if (arrays != null && this.mPoolSize > 0) {
            int lastPooledIndex = this.mPoolSize - 1;
            Object instance = arrays[lastPooledIndex];
            arrays[lastPooledIndex] = null;
            --this.mPoolSize;
            return (T)instance;
        }
        return null;
    }

    @Override
    public boolean release(T instance) {
        if (this.isInPool(instance)) {
            return true;
        }
        Object[] arrays = this.mPool.get();
        if (arrays == null) {
            return false;
        }
        if (this.mPoolSize < arrays.length) {
            arrays[this.mPoolSize] = instance;
            ++this.mPoolSize;
            return true;
        }
        return false;
    }

    private boolean isInPool(T instance) {
        Object[] arrays = this.mPool.get();
        if (arrays == null) {
            return false;
        }
        for (int i = 0; i < this.mPoolSize; ++i) {
            if (arrays[i] != instance) continue;
            return true;
        }
        return false;
    }

    public void removeAll() {
        this.mPool.remove();
    }
}

