/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.common;

import android.util.LruCache;
import com.transsion.aiservice.common.ObjectPool;
import com.transsion.aiservice.common.RecyclerObj;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ObjectPoolManager {
    private static volatile ObjectPoolManager sInstant;
    LruCache<Class<?>, ObjectPool<Object>> objectPoolLruCache = new LruCache(10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectPoolManager getInstance() {
        if (sInstant != null) return sInstant;
        Class<ObjectPoolManager> clazz = ObjectPoolManager.class;
        synchronized (ObjectPoolManager.class) {
            if (sInstant != null) return sInstant;
            sInstant = new ObjectPoolManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstant;
        }
    }

    private ObjectPoolManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RecyclerObj> void release(T instance) {
        if (instance == null) {
            return;
        }
        Class<?> clazz = instance.getClass();
        ObjectPool<T> pool = (ObjectPool<T>)this.objectPoolLruCache.get(clazz);
        if (pool == null) {
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                pool = new ObjectPool<T>(5);
                this.objectPoolLruCache.put(clazz, pool);
            }
        }
        pool.release(instance);
    }

    public <T extends RecyclerObj> T acquire(Class<T> tClass) {
        if (tClass == null) {
            return null;
        }
        Object result = null;
        ObjectPool pool = (ObjectPool)this.objectPoolLruCache.get(tClass);
        if (pool != null) {
            result = pool.acquire();
        }
        if (result == null) {
            try {
                Constructor<T> constructor = tClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                result = constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return (T)((RecyclerObj)result);
    }
}

