/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.common;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.LruCache;
import com.transsion.aiservice.common.PackageHelperInterface;
import com.transsion.aiservice.common.utils.AiLog;

public class PackageHelperInterfaceImpl
implements PackageHelperInterface {
    private static final String TAG = "PackageHelperInterfaceImpl";
    LruCache<String, PackageInfo> resultLruCache = new LruCache(5);

    @Override
    public boolean isAppExistAndEnabled(Context context, String packageName, boolean isRefresh) {
        if (packageName == null || "".equals(packageName)) {
            return false;
        }
        PackageInfo packageInfo = null;
        ApplicationInfo applicationInfo = null;
        if (!isRefresh) {
            packageInfo = this.getPackageInfo("isEnable_" + packageName);
        }
        if (packageInfo == null || !packageInfo.isValidity()) {
            try {
                if (context.getPackageManager().getPackageInfo(packageName, 0) != null) {
                    applicationInfo = context.getPackageManager().getApplicationInfo(packageName, 0);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                AiLog.w(TAG, "isAppExistAndEnabled" + (Object)((Object)e));
            }
            packageInfo = new PackageInfo();
            packageInfo.setBoolResult(applicationInfo != null && applicationInfo.enabled);
        }
        return packageInfo.getBoolResult();
    }

    @Override
    public boolean isSystemSign(Context context, String packageName, boolean isRefresh) {
        boolean result;
        if (packageName == null || "".equals(packageName)) {
            AiLog.d(TAG, "pkg is empty, isSystemSign => false");
            return false;
        }
        PackageInfo packageInfo = null;
        if (!isRefresh) {
            packageInfo = this.getPackageInfo("isEnable_" + packageName);
        }
        if (packageInfo == null || !packageInfo.isValidity()) {
            packageInfo = new PackageInfo();
            packageInfo.setBoolResult(0 == context.getPackageManager().checkSignatures(packageName, "android"));
        }
        if (!(result = packageInfo.getBoolResult())) {
            AiLog.d(TAG, "isSystemSign => false");
        }
        return result;
    }

    @Override
    public boolean isSystemSign(Context context, boolean isRefresh) {
        return this.isSystemSign(context, context.getPackageName(), isRefresh);
    }

    public PackageInfo getPackageInfo(String key) {
        return (PackageInfo)this.resultLruCache.get((Object)key);
    }

    private static class PackageInfo {
        private static final long validityTime = 600000L;
        private String mStringResult;
        private boolean mBoolResult;
        private long createTime = System.currentTimeMillis();

        public String getStringResult() {
            return this.mStringResult;
        }

        public void setStringResult(String result) {
            this.mStringResult = result;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(long createTime) {
            this.createTime = createTime;
        }

        public boolean isValidity() {
            return System.currentTimeMillis() - this.createTime < 600000L;
        }

        public boolean getBoolResult() {
            return this.mBoolResult;
        }

        public void setBoolResult(boolean mBoolResult) {
            this.mBoolResult = mBoolResult;
        }
    }
}

