/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.common;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.transsion.aiservice.common.utils.AiLog;

public final class WorkerHandler {
    private static volatile WorkerHandler sInstant;
    private final String TAG = "WorkerHandler";
    private final Thread.UncaughtExceptionHandler sDefaultExceptionHandler = (t, e) -> {
        e.printStackTrace();
        AiLog.w("WorkerHandler", "catch exception from " + e.getMessage());
    };
    volatile Handler handler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WorkerHandler getInstance() {
        if (sInstant != null) return sInstant;
        Class<WorkerHandler> clazz = WorkerHandler.class;
        synchronized (WorkerHandler.class) {
            if (sInstant != null) return sInstant;
            sInstant = new WorkerHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstant;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Runnable runnable) {
        if (!this.isAlive()) {
            WorkerHandler workerHandler = this;
            synchronized (workerHandler) {
                if (!this.isAlive()) {
                    this.handler = this.createHandler("standWorker");
                }
            }
        }
        this.handler.post(runnable);
    }

    private boolean isAlive() {
        if (this.handler == null) {
            return false;
        }
        Looper looper = this.handler.getLooper();
        if (looper == null) {
            return false;
        }
        Thread thread = looper.getThread();
        return thread != null && thread.isAlive();
    }

    public Handler createHandler(String name) {
        HandlerThread thread = this.getHandlerThread(name);
        return new Handler(thread.getLooper());
    }

    public Looper createLooper(String name) {
        HandlerThread thread = this.getHandlerThread(name);
        return thread.getLooper();
    }

    public HandlerThread getHandlerThread(String name) {
        HandlerThread thread = new HandlerThread(name, 5);
        thread.setUncaughtExceptionHandler(this.sDefaultExceptionHandler);
        thread.start();
        return thread;
    }
}

