/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.common.event;

import android.os.Handler;
import android.os.Looper;
import android.util.LruCache;
import androidx.annotation.NonNull;
import com.transsion.aiservice.common.WorkerHandler;
import com.transsion.aiservice.common.event.SimpleBaseListener;
import com.transsion.aiservice.common.event.SimpleEvent;
import com.transsion.aiservice.common.event.SimpleObserver;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleEventBus {
    private static final Object sLock = new Object();
    private static volatile SimpleEventBus sDefaultBus;
    private final LruCache<Class, List<Class>> mObserverMessageCache = new LruCache(10);
    private final Map<String, List<Class<?>>> mBusEventMap = new ConcurrentHashMap();
    private final Map<Class<?>, Subscriber> mObserverList = new ConcurrentHashMap();
    private Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleEventBus getDefault() {
        if (sDefaultBus == null) {
            Object object = sLock;
            synchronized (object) {
                if (sDefaultBus == null) {
                    sDefaultBus = new SimpleEventBus(null);
                }
            }
        }
        return sDefaultBus;
    }

    private SimpleEventBus(Looper looper) {
        this.mHandler = looper != null ? new Handler(looper) : WorkerHandler.getInstance().createHandler("event_bus_worker");
    }

    @NonNull
    private List<Class> getAllSupportSub(Class<?> clazz) {
        ArrayList<Class> classes = (ArrayList<Class>)this.mObserverMessageCache.get(clazz);
        if (classes == null) {
            classes = new ArrayList<Class>();
        }
        for (Class<?> classItem : clazz.getInterfaces()) {
            if (!SimpleEventBus.isTargetInterface(classItem)) {
                if (SimpleBaseListener.class.isAssignableFrom(classItem)) {
                    classes.add(classItem);
                }
                classes.addAll(this.getAllSupportSub(classItem));
                continue;
            }
            classes.add(classItem);
        }
        return classes;
    }

    private static boolean isTargetInterface(Class clazz) {
        Class<?>[] items = clazz.getInterfaces();
        return items.length == 1 && SimpleEventBus.isBaseListener(items[0]);
    }

    private static boolean isBaseListener(Class clazz) {
        return SimpleBaseListener.class.getName().equals(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Looper looper) {
        if (sDefaultBus == null) {
            Object object = sLock;
            synchronized (object) {
                if (sDefaultBus == null) {
                    sDefaultBus = new SimpleEventBus(looper);
                }
            }
        }
    }

    public void send(BaseEvent event) {
        this.mHandler.post(() -> this.sendMessage(event.getEventName(), event));
    }

    public void post(String observedName, Object params) {
        this.mHandler.post(() -> this.sendMessage(observedName, params));
    }

    private void sendMessage(String observedName, Object params) {
        List<Class<?>> classList = this.mBusEventMap.get(observedName);
        if (classList == null) {
            return;
        }
        for (Class<?> itemClass : classList) {
            Subscriber subscriber = this.mObserverList.get(itemClass);
            if (subscriber == null) continue;
            subscriber.execute(observedName, params);
        }
    }

    public void unRegister(SimpleObserver observer) {
        if (observer == null) {
            return;
        }
        List<Class> observersClass = this.getAllSupportSub(observer.getClass());
        for (Class itemClass : observersClass) {
            Subscriber subscriber = this.getObserverStub(itemClass, false);
            if (subscriber == null) continue;
            subscriber.unregister(observer);
        }
    }

    public void register(SimpleObserver observer) {
        this.registerSubscriber(observer);
    }

    public void registerSubscriber(SimpleObserver observer) {
        if (observer == null) {
            return;
        }
        List<Class> observersClass = this.getAllSupportSub(observer.getClass());
        for (Class itemClass : observersClass) {
            Subscriber subscriber = this.getObserverStub(itemClass, true);
            subscriber.add(observer);
        }
    }

    private Subscriber getObserverStub(Class itemClass, boolean recreate) {
        Subscriber subscriber = this.mObserverList.get(itemClass);
        if (subscriber == null && recreate) {
            subscriber = new Subscriber(itemClass);
            this.mObserverList.put(itemClass, subscriber);
        }
        return subscriber;
    }

    private void scanMethod(Map<String, Method> methodMap, Class<?> observerClass) {
        Method[] methods;
        for (Method method : methods = observerClass.getDeclaredMethods()) {
            SimpleEvent simpleEvent = method.getAnnotation(SimpleEvent.class);
            if (simpleEvent == null) continue;
            method.setAccessible(true);
            this.addEventMap(simpleEvent.value(), observerClass);
            methodMap.put(simpleEvent.value(), method);
        }
    }

    private void addEventMap(String value, Class<?> observerClass) {
        List classList = this.mBusEventMap.computeIfAbsent(value, k -> new ArrayList());
        if (!classList.contains(observerClass)) {
            classList.add(observerClass);
        }
    }

    public static interface BaseEvent {
        public String getEventName();
    }

    private class Subscriber {
        private final Class mOwnerClass;
        private List<WeakReference<SimpleObserver>> mObserver = new ArrayList<WeakReference<SimpleObserver>>();
        private final Map<String, Method> mFunctionEvents = new HashMap<String, Method>();

        private Subscriber(Class mOwnerClass) {
            this.mOwnerClass = mOwnerClass;
            SimpleEventBus.this.scanMethod(this.mFunctionEvents, this.mOwnerClass);
        }

        private void add(SimpleObserver simpleObserver) {
            if (this.findRegisteredSubscriber(simpleObserver)) {
                return;
            }
            this.mObserver.add(new WeakReference<SimpleObserver>(simpleObserver));
        }

        private boolean findRegisteredSubscriber(SimpleObserver observer) {
            for (WeakReference<SimpleObserver> item : this.mObserver) {
                if (observer != item.get()) continue;
                return true;
            }
            return false;
        }

        private void unregister(SimpleObserver observer) {
            this.mObserver.removeIf(it -> observer == it.get());
        }

        private boolean isEmpty() {
            return this.mObserver.isEmpty();
        }

        private void execute(String name, Object params) {
            Method method = this.mFunctionEvents.get(name);
            if (method == null) {
                return;
            }
            try {
                for (WeakReference<SimpleObserver> item : this.mObserver) {
                    SimpleObserver simpleObserver = (SimpleObserver)item.get();
                    if (simpleObserver == null) continue;
                    method.invoke((Object)simpleObserver, params);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

