/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.transsion.aiservice.common.ObjectPoolManager;
import com.transsion.aiservice.common.RecyclerObj;
import com.transsion.aiservice.common.Utils;
import com.transsion.aiservice.common.utils.AiLog;
import com.transsion.aiservice.oxygenbus.core.GsonTask;
import com.transsion.aiservice.oxygenbus.core.OxyGenBridge;
import com.transsion.aiservice.oxygenbus.core.OxyGenCallBack;
import com.transsion.aiservice.oxygenbus.core.ann.TransType;
import com.transsion.aiservice.oxygenbus.core.channel.local.LocalServiceProcess;
import com.transsion.aiservice.oxygenbus.core.channel.remote.RemoteProcess;
import com.transsion.aiservice.oxygenbus.core.trans.CommonTransData;
import com.transsion.aiservice.oxygenbus.datacover.OxyGenDataPackage;
import com.transsion.aiservice.oxygenbus.error.ExceptionManager;
import java.lang.reflect.Type;

public class OxyGenBus {
    private static Context SApplication;

    public static void initApplication(Context context) {
        SApplication = context.getApplicationContext();
        OxyGenBridge.getInstance().registerAdapter(1, new LocalServiceProcess());
        OxyGenBridge.getInstance().registerAdapter(2, new RemoteProcess());
    }

    public static Context getApplication() {
        return SApplication;
    }

    public static <T> void register(CommonTransData transData, OxyGenCallBack<T> callBack) {
        transData.setActionType(101);
        OxyGenBridge.getInstance().getCallBackController().register(transData, callBack);
    }

    public static void unRegister(CommonTransData transData, OxyGenCallBack callBack) {
    }

    public static <T> void request(CommonTransData transData, OxyGenCallBack<T> callBack) {
        OxyGenBridge.getInstance().getCallBackController().asyncRequest(transData, callBack);
    }

    public static <T> OxyGenDataPackage<T> request(Type tClass, CommonTransData transData) {
        if (tClass == Void.TYPE || tClass == Void.class) {
            transData.setActionType(105);
        }
        if (transData.getActionType() == 105) {
            OxyGenBus.requestOnWay(transData);
            return ExceptionManager.getErrorDataPackage("request_one_way");
        }
        try {
            if (Utils.isMainThread()) {
                AiLog.e("OxyGenBus", "sync not allow in main thread");
            }
            return OxyGenBridge.getInstance().getCallBackController().fakeSyncRequest(tClass, transData);
        }
        catch (InterruptedException e) {
            return ExceptionManager.getErrorDataPackage(e.getMessage());
        }
    }

    public static void requestOnWay(CommonTransData transData) {
        OxyGenBridge.getInstance().getCallBackController().requestInWorker(transData);
    }

    public static class Builder
    implements RecyclerObj {
        private int actionType = 100;
        private int serviceType;
        private String module;
        private String funName;
        private Object mParamData;
        private long mTimeOut = 0L;

        public static Builder create(@TransType int transType) {
            Builder builder = ObjectPoolManager.getInstance().acquire(Builder.class);
            return builder;
        }

        public static Builder create() {
            Builder builder = ObjectPoolManager.getInstance().acquire(Builder.class);
            return builder;
        }

        public int getActionType() {
            return this.actionType;
        }

        public Builder setActionType(int actionType) {
            this.actionType = actionType;
            return this;
        }

        public long getTimeOut() {
            return this.mTimeOut;
        }

        public Builder setTimeOut(long mTimeOut) {
            this.mTimeOut = mTimeOut;
            return this;
        }

        public int getServiceType() {
            return this.serviceType;
        }

        public Builder setServiceType(int serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public String getModule() {
            return this.module;
        }

        public Builder setServiceName(String name) {
            this.module = name;
            return this;
        }

        public String getFunName() {
            return this.funName;
        }

        public Builder setFunName(String funName) {
            this.funName = funName;
            return this;
        }

        public Builder setParam(Object obj) {
            this.mParamData = obj;
            return this;
        }

        @Override
        public boolean isRelease() {
            return TextUtils.isEmpty((CharSequence)this.module) || TextUtils.isEmpty((CharSequence)this.funName);
        }

        @Override
        public Gson getGson() {
            return GsonTask.getGson();
        }

        @Override
        public void release() {
            this.module = "";
            this.funName = "";
            this.mParamData = null;
            this.actionType = 100;
            ObjectPoolManager.getInstance().release(this);
        }

        public CommonTransData build() {
            CommonTransData result = CommonTransData.get().setServiceType(this.getServiceType()).setData(this.module, this.funName, this.mParamData, this.actionType, this.mTimeOut);
            this.release();
            return result;
        }
    }
}

