/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.build;

import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.transsion.aiservice.common.ObjectPoolManager;
import com.transsion.aiservice.oxygenbus.BaseRecyclerObjImpl;
import com.transsion.aiservice.oxygenbus.core.GsonTask;
import java.io.Serializable;
import java.util.ArrayList;

public final class OxyGenMap
extends BaseRecyclerObjImpl
implements Parcelable {
    Bundle bundle = new Bundle();
    public static final Parcelable.Creator<OxyGenMap> CREATOR = new Parcelable.Creator<OxyGenMap>(){

        public OxyGenMap createFromParcel(Parcel in) {
            return OxyGenMap.create().setData(in);
        }

        public OxyGenMap[] newArray(int size) {
            return new OxyGenMap[size];
        }
    };

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBundle(this.bundle);
    }

    public int describeContents() {
        return 0;
    }

    protected OxyGenMap setData(Parcel in) {
        this.bundle = in.readBundle();
        return this;
    }

    public static OxyGenMap create() {
        return ObjectPoolManager.getInstance().acquire(OxyGenMap.class);
    }

    public OxyGenMap put(String key, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            this.bundle.putFloat(key, ((Float)value).floatValue());
        } else if (value instanceof Short) {
            this.bundle.putShort(key, ((Short)value).shortValue());
        } else if (value instanceof Long) {
            this.bundle.putLong(key, ((Long)value).longValue());
        } else if (value instanceof String) {
            this.bundle.putString(key, (String)value);
        } else if (value instanceof Double) {
            this.bundle.putDouble(key, ((Double)value).doubleValue());
        } else if (value instanceof Byte) {
            this.bundle.putByte(key, ((Byte)value).byteValue());
        } else if (value instanceof Bundle) {
            this.bundle.putBundle(key, (Bundle)value);
        } else if (value instanceof Parcelable) {
            this.bundle.putParcelable(key, (Parcelable)value);
        } else if (value instanceof ArrayList) {
            this.bundle.putParcelableArrayList(key, (ArrayList)value);
        } else if (value.getClass().isArray()) {
            if (value instanceof int[]) {
                this.bundle.putIntArray(key, (int[])value);
            } else if (value instanceof long[]) {
                this.bundle.putLongArray(key, (long[])value);
            } else if (value instanceof float[]) {
                this.bundle.putFloatArray(key, (float[])value);
            } else if (value instanceof double[]) {
                this.bundle.putDoubleArray(key, (double[])value);
            } else if (value instanceof Parcelable[]) {
                this.bundle.putParcelableArray(key, (Parcelable[])value);
            } else if (value instanceof byte[]) {
                this.bundle.putByteArray(key, (byte[])value);
            } else if (value instanceof short[]) {
                this.bundle.putShortArray(key, (short[])value);
            } else if (value instanceof char[]) {
                this.bundle.putCharArray(key, (char[])value);
            }
        } else {
            try {
                this.bundle.putString(key, GsonTask.getGson().toJson(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public Bundle getBundle(String key) {
        return this.bundle.getBundle(key);
    }

    public IBinder getBinder(String key) {
        return this.bundle.getBinder(key);
    }

    public Serializable getSerializable(String key) {
        return this.bundle.getSerializable(key);
    }

    public <T extends Parcelable> T getParcelable(String key) {
        return (T)this.bundle.getParcelable(key);
    }

    public Short getShort(String key) {
        return this.bundle.getShort(key);
    }

    public Long getLong(String key) {
        return this.bundle.getLong(key);
    }

    public String getString(String key, String defaultValue) {
        return this.bundle.getString(key, defaultValue);
    }

    public byte getByte(String key) {
        return this.bundle.getByte(key);
    }

    public char getChar(String key) {
        return this.bundle.getChar(key);
    }

    public double getDouble(String key, double defaultValue) {
        return this.bundle.getDouble(key, defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        return this.bundle.getInt(key, defaultValue);
    }

    @Override
    public boolean isRelease() {
        return this.bundle.isEmpty();
    }

    @Override
    public void release() {
        this.bundle.clear();
        super.release();
    }

    public void reset() {
        this.bundle.clear();
    }
}

