/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.core;

import com.transsion.aiservice.oxygenbus.core.DeviceAddressController;
import com.transsion.aiservice.oxygenbus.core.ProcessAdapter;
import com.transsion.aiservice.oxygenbus.core.RequestHandler;
import com.transsion.aiservice.oxygenbus.core.callback.OxyGenCallBackController;
import com.transsion.aiservice.oxygenbus.core.trans.CommonTransData;
import com.transsion.aiservice.oxygenbus.service.OxyGenServerHelper;

public class OxyGenBridge {
    private static final String TAG = "OxyGenBridge";
    private static OxyGenBridge sInstance;
    private DeviceAddressController mAddressController;
    private OxyGenCallBackController mCallBackController;

    private OxyGenBridge() {
        this.initBridge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OxyGenBridge getInstance() {
        if (sInstance != null) return sInstance;
        Class<OxyGenBridge> clazz = OxyGenBridge.class;
        synchronized (OxyGenBridge.class) {
            if (sInstance != null) return sInstance;
            sInstance = new OxyGenBridge();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void registerAdapter(int type, ProcessAdapter adapter) {
        this.mAddressController.registerAdapter(type, adapter);
        this.mCallBackController.registerCallBackTasker(type, adapter);
    }

    private void initBridge() {
        this.mAddressController = new DeviceAddressController();
        this.mCallBackController = new OxyGenCallBackController();
    }

    public OxyGenCallBackController getCallBackController() {
        return this.mCallBackController;
    }

    public Object request(CommonTransData transData) {
        ProcessAdapter processAdapter;
        int type = transData.getServiceType();
        if (type == -1 && OxyGenServerHelper.isLocalServer(transData.getServiceName())) {
            transData.setServiceType(1);
        }
        if ((processAdapter = this.getAddressProcess(type)) == null) {
            transData.throwClientError("miss ProcessAdapter in type =" + type);
            return null;
        }
        return this.request(processAdapter, transData);
    }

    public Object request(ProcessAdapter processAdapter, CommonTransData transData) {
        RequestHandler requestHandler = processAdapter.getRequestHandler(transData);
        if (requestHandler == null) {
            transData.throwClientError("miss requestHandler in=" + transData.getServiceName() + transData.getFunctionName());
            return null;
        }
        return requestHandler.getChannel().request(processAdapter, transData);
    }

    public ProcessAdapter getAddressProcess(int type) {
        return this.mAddressController.getAdapter(type);
    }
}

