/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.core.callback;

import com.transsion.aiservice.oxygenbus.core.OxyGenCallBack;
import com.transsion.aiservice.oxygenbus.core.trans.BaseTransData;
import com.transsion.aiservice.oxygenbus.core.trans.CommonTransData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CallBackCache {
    private static volatile CallBackCache sInstant;
    public static final ThreadLocal<OxyGenCallBack> CURRENT_CALL_BACK;
    public final Object mSetLock = new Object();
    private final Map<Integer, OxyGenCallBack> mCallBackMap = new ConcurrentHashMap<Integer, OxyGenCallBack>(10);
    private final Map<String, Map<OxyGenCallBack, CommonTransData>> mListenerMap = new ConcurrentHashMap<String, Map<OxyGenCallBack, CommonTransData>>(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CallBackCache getInstance() {
        if (sInstant != null) return sInstant;
        Class<CallBackCache> clazz = CallBackCache.class;
        synchronized (CallBackCache.class) {
            if (sInstant != null) return sInstant;
            sInstant = new CallBackCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstant;
        }
    }

    public boolean hasValidCallBack(int hashcode) {
        return this.mCallBackMap.containsKey(hashcode);
    }

    public void addCallback(BaseTransData transData, OxyGenCallBack callBack) {
        int hashCode = CallBackCache.getHashCode(callBack);
        transData.setCallbackHashCode(hashCode);
        this.mCallBackMap.put(hashCode, callBack);
    }

    private static int getHashCode(OxyGenCallBack callBack) {
        return System.identityHashCode(callBack);
    }

    public void removeCallback(OxyGenCallBack callBack) {
    }

    public void removeCallback(int hashCode) {
        this.mCallBackMap.remove(hashCode);
    }

    public OxyGenCallBack getCallBack(int hashCode, boolean removeTag) {
        if (removeTag) {
            return this.mCallBackMap.remove(hashCode);
        }
        return this.mCallBackMap.get(hashCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(BaseTransData transData, OxyGenCallBack callBack) {
        transData.setActionType(102);
        String identification = CallBackCache.getRegisterIdentification(transData.getServiceName(), transData.getFunctionName());
        Map<OxyGenCallBack, CommonTransData> callBackSet = this.mListenerMap.get(identification);
        if (callBackSet != null) {
            Object object = this.mSetLock;
            synchronized (object) {
                callBackSet.remove(callBack);
                return callBackSet.size() != 0;
            }
        }
        return true;
    }

    public static String getRegisterIdentification(String moduleName, String funName) {
        return moduleName + "_" + funName;
    }

    public Map<OxyGenCallBack, CommonTransData> getRegisters(String identification) {
        return this.mListenerMap.get(identification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(CommonTransData transData, OxyGenCallBack callBack) {
        transData.setActionType(101);
        int hashCode = System.identityHashCode(callBack);
        transData.setCallbackHashCode(hashCode);
        String identification = CallBackCache.getRegisterIdentification(transData.getServiceName(), transData.getFunctionName());
        Map<OxyGenCallBack, CommonTransData> callBackSet = this.mListenerMap.get(identification);
        if (callBackSet == null) {
            callBackSet = new ConcurrentHashMap<OxyGenCallBack, CommonTransData>();
            Object object = this.mSetLock;
            synchronized (object) {
                this.mListenerMap.put(identification, callBackSet);
            }
        }
        callBackSet.put(callBack, transData);
    }

    static {
        CURRENT_CALL_BACK = new ThreadLocal();
    }
}

