/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.core.callback;

import com.transsion.aiservice.common.utils.AiLog;
import com.transsion.aiservice.oxygenbus.OxyGenThread;
import com.transsion.aiservice.oxygenbus.core.OxyGenBridge;
import com.transsion.aiservice.oxygenbus.core.OxyGenCallBack;
import com.transsion.aiservice.oxygenbus.core.ProcessAdapter;
import com.transsion.aiservice.oxygenbus.core.ResultDataManager;
import com.transsion.aiservice.oxygenbus.core.callback.CallBackCache;
import com.transsion.aiservice.oxygenbus.core.channel.BaseEvent;
import com.transsion.aiservice.oxygenbus.core.channel.CallBackTasker;
import com.transsion.aiservice.oxygenbus.core.channel.local.ReturnState;
import com.transsion.aiservice.oxygenbus.core.trans.CommonTransData;
import com.transsion.aiservice.oxygenbus.datacover.OxyGenDataPackage;
import com.transsion.aiservice.oxygenbus.error.ExceptionManager;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class OxyGenCallBackController {
    public static final String TAG = "OxyGenCallBackController";
    private final Map<Integer, CallBackTasker> mCallBackTaskerMap = new ConcurrentHashMap<Integer, CallBackTasker>(5);

    public void registerCallBackTasker(int type, ProcessAdapter adapter) {
        CallBackTasker callBackTasker = adapter.getCallBackTasker();
        if (callBackTasker != null) {
            this.mCallBackTaskerMap.put(type, callBackTasker);
        }
    }

    private CallBackTasker getCallBackTask(int type) {
        return this.mCallBackTaskerMap.get(type);
    }

    public void asyncRequest(CommonTransData baseTransData, OxyGenCallBack<?> oxyGenCallBack) {
        CallBackTasker callBackTasker = this.getCallBackTask(1);
        if (callBackTasker == null) {
            AiLog.e(TAG, "not find callBackTasker in type :1");
            return;
        }
        callBackTasker.saveCallBack(baseTransData, oxyGenCallBack);
        this.requestInWorker(baseTransData);
    }

    public <T> OxyGenDataPackage<T> fakeSyncRequest(Type tClass, CommonTransData transData) throws InterruptedException {
        CountDownLatch mCountDownLatch = new CountDownLatch(1);
        SyncCallBack callBack = new SyncCallBack(mCountDownLatch, tClass);
        CallBackCache.CURRENT_CALL_BACK.set(callBack);
        this.asyncRequest(transData, callBack);
        mCountDownLatch.await(5000L, TimeUnit.MILLISECONDS);
        if (callBack.mResult == null) {
            return ExceptionManager.getErrorDataPackage("request time out");
        }
        return callBack.mResult;
    }

    public void onEvent(int type, BaseEvent event) {
        CallBackTasker callBackTasker = this.getCallBackTask(type);
        if (callBackTasker == null) {
            AiLog.e(TAG, "not find callBackTasker in type :" + type);
            return;
        }
        callBackTasker.onEvent(event);
    }

    public void notifyData(CommonTransData commonResultTransData) {
        for (CallBackTasker callBackTasker : this.mCallBackTaskerMap.values()) {
            callBackTasker.onEvent(BaseEvent.create(104, commonResultTransData));
        }
    }

    public void unregister(CommonTransData transData, OxyGenCallBack callBack) {
        if (!this.unregisterInLocal(transData, callBack)) {
            transData.setActionType(102);
            this.requestInWorker(transData);
        }
    }

    public boolean unregisterInLocal(CommonTransData transData, OxyGenCallBack callBack) {
        CallBackTasker callBackTasker = this.getCallBackTask(1);
        if (callBackTasker == null) {
            AiLog.e(TAG, "not find callBackTasker in type :1");
            return false;
        }
        return callBackTasker.unregister(transData, callBack);
    }

    public void requestInWorker(CommonTransData transData) {
        OxyGenThread.getMsgHandler().post(() -> {
            ExceptionManager.getInstance().setRequestTimeOut(transData.getCallbackHashCode(), transData.getRequestTimeout());
            Object result = OxyGenBridge.getInstance().request(transData);
            int callBackId = transData.getCallbackHashCode();
            boolean haveCallBack = false;
            if (result == null || result == ReturnState.ONE_WAY) {
                CallBackCache.getInstance().removeCallback(callBackId);
                return;
            }
            if (result instanceof CommonTransData && ((CommonTransData)result).getActionType() == 110) {
                ((CommonTransData)result).setCallbackHashCode(callBackId);
                this.responseToLocal((CommonTransData)result);
                haveCallBack = true;
            }
            if (!haveCallBack) {
                transData.throwClientError("this result not have haveCallBack" + result);
            }
        });
    }

    public void sendCallBack(CommonTransData transData, Object object) {
        CommonTransData resultData = ResultDataManager.getResultData(object);
        if (transData == null) {
            AiLog.e(TAG, "callBack data is NUll");
            return;
        }
        if (transData.isCallBackRequest()) {
            resultData.setCallbackHashCode(transData.getCallbackHashCode());
            resultData.setClientPackageName(transData.getClientPackageName());
            this.response(resultData, transData.getServiceType());
        } else {
            AiLog.e(TAG, "this is not callBack");
        }
    }

    public void responseToLocal(CommonTransData commonResultTransData) {
        this.response(commonResultTransData, 1);
    }

    public void response(CommonTransData commonResultTransData, int type) {
        CallBackTasker callBackTasker = this.getCallBackTask(type);
        if (callBackTasker == null) {
            commonResultTransData.throwServerError("OxyGenCallBackController:not find callBackTasker in type :1");
            return;
        }
        callBackTasker.onResponse(commonResultTransData);
    }

    public void register(CommonTransData transData, OxyGenCallBack callBack) {
        CallBackTasker callBackTasker = this.getCallBackTask(1);
        if (callBackTasker == null) {
            AiLog.e(TAG, "not find callBackTasker in type :1");
            return;
        }
        callBackTasker.register(transData, callBack);
        this.requestInWorker(transData);
    }

    public static class SyncCallBack
    implements OxyGenCallBack {
        private final CountDownLatch mCountDownLatch;
        private OxyGenDataPackage mResult;
        private final Type dataType;

        @Override
        public Type getResultType() {
            return this.dataType;
        }

        private SyncCallBack(CountDownLatch mServiceConnected, Type dataType) {
            this.mCountDownLatch = mServiceConnected;
            this.dataType = dataType;
        }

        public void call(OxyGenDataPackage commonTransData) {
            this.mResult = commonTransData;
            if (this.mCountDownLatch != null) {
                this.mCountDownLatch.countDown();
            }
        }
    }
}

