/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.core.channel.local;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.transsion.aiservice.common.ObjectPoolManager;
import com.transsion.aiservice.common.RecyclerObj;
import com.transsion.aiservice.common.utils.AiLog;
import com.transsion.aiservice.oxygenbus.OxyGenThread;
import com.transsion.aiservice.oxygenbus.core.OxyGenCallBack;
import com.transsion.aiservice.oxygenbus.core.callback.CallBackCache;
import com.transsion.aiservice.oxygenbus.core.channel.CallBackTasker;
import com.transsion.aiservice.oxygenbus.core.trans.CommonTransData;
import com.transsion.aiservice.oxygenbus.datacover.DataParserManager;
import com.transsion.aiservice.oxygenbus.datacover.OxyGenDataPackage;
import com.transsion.aiservice.oxygenbus.error.ExceptionManager;
import com.transsion.aiservice.oxygenbus.service.PluginServiceImpl;
import java.lang.reflect.Type;
import java.util.Map;

public class LocalCallBackTasker
implements CallBackTasker<CommonTransData, CommonTransData> {
    private final int CALL_BACK_OBSERVER = 101;
    private static final String TAG = "LocalCallBackTasker";
    private final Handler MESSAGE_HANDLER = new Handler(OxyGenThread.getEventBusHandler().getLooper()){

        public void handleMessage(@NonNull Message msg) {
            if (msg.what == 101) {
                ((ObserverMessage)msg.obj).sendMsg();
            }
            super.handleMessage(msg);
        }
    };

    @Override
    public void register(CommonTransData data, OxyGenCallBack callBack) {
        CallBackCache.getInstance().register(data, callBack);
    }

    @Override
    public boolean unregister(CommonTransData data, OxyGenCallBack callBack) {
        return CallBackCache.getInstance().unregister(data, callBack);
    }

    @Override
    public void onResponse(CommonTransData result) {
        OxyGenCallBack callBack = null;
        if (result.isCallBackRequest()) {
            ExceptionManager.getInstance().removeTimeOutMessage(result.getCallbackHashCode());
            callBack = CallBackCache.getInstance().getCallBack(result.getCallbackHashCode(), true);
        }
        if (callBack == null) {
            callBack = this.getFakeCallBack();
        }
        if (callBack != null) {
            LocalCallBackTasker.callBackSuccess(result, callBack);
        }
        if (callBack == null) {
            AiLog.e(TAG, "not find callBack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callBackSuccess(CommonTransData result, OxyGenCallBack callBack) {
        if (callBack == null) {
            return;
        }
        Type type = callBack.getResultType();
        if (type == null) {
            type = DataParserManager.instanceActualTypeArguments(callBack);
        }
        String obj = null;
        int resultCode = 201;
        if (result.getActionType() == 110) {
            resultCode = 202;
            obj = String.valueOf(result.getParams());
        } else if (type != null) {
            obj = DataParserManager.getInstance().cover(result, type);
            resultCode = 201;
        }
        OxyGenCallBack oxyGenCallBack = callBack;
        synchronized (oxyGenCallBack) {
            callBack.call(OxyGenDataPackage.create(result, obj).setResultCode(resultCode));
        }
    }

    @Override
    public void saveCallBack(CommonTransData data, OxyGenCallBack callBack) {
        CallBackCache.getInstance().addCallback(data, callBack);
    }

    @Override
    public void onBroadcast(CommonTransData result) {
        this.postBroadcast(result);
    }

    @Override
    public void onErr(CommonTransData result) {
        this.onResponse(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBroadcast(CommonTransData observerData) {
        block13: {
            if (!TextUtils.isEmpty((CharSequence)observerData.getRegisterTarget())) {
                try {
                    Map<OxyGenCallBack, CommonTransData> callBackMap = CallBackCache.getInstance().getRegisters(observerData.getRegisterTarget());
                    if (callBackMap != null) {
                        Object object = CallBackCache.getInstance().mSetLock;
                        synchronized (object) {
                            for (Map.Entry<OxyGenCallBack, CommonTransData> entry : callBackMap.entrySet()) {
                                if (entry.getKey() == null) continue;
                                if (!observerData.isRelease() && observerData.getTag() != null) {
                                    if (observerData.getTag() instanceof PluginServiceImpl) {
                                        if (!this.filterObserver((PluginServiceImpl)observerData.getTag(), entry.getValue())) {
                                            AiLog.d("LocalEventManager", "filterObserver: " + observerData.getTag().toString());
                                            continue;
                                        }
                                    } else {
                                        AiLog.e("LocalEventManager", "error observerData type" + observerData.getTag());
                                    }
                                } else {
                                    AiLog.e("LocalEventManager", "observerData or TAG is NUll" + observerData.getTag());
                                }
                                Message message = this.MESSAGE_HANDLER.obtainMessage();
                                message.what = 101;
                                message.obj = ObjectPoolManager.getInstance().acquire(ObserverMessage.class).setData(entry.getKey(), observerData);
                                this.MESSAGE_HANDLER.sendMessage(message);
                            }
                            break block13;
                        }
                    }
                    AiLog.e("LocalEventManager", "this function no observer");
                }
                catch (Exception e) {
                    AiLog.w("LocalEventManager", "onBroadcast err:" + e);
                }
            }
        }
    }

    private boolean filterObserver(PluginServiceImpl pluginService, CommonTransData commonTransData) {
        return pluginService.filterObserver(commonTransData);
    }

    public static class ObserverMessage
    implements RecyclerObj {
        private OxyGenCallBack callBack;
        private CommonTransData resultData;

        private ObserverMessage setData(OxyGenCallBack callBack, CommonTransData resultData) {
            this.callBack = callBack;
            this.resultData = resultData;
            return this;
        }

        private void sendMsg() {
            LocalCallBackTasker.callBackSuccess(this.resultData, this.callBack);
        }

        @Override
        public boolean isRelease() {
            return this.callBack == null;
        }

        @Override
        public void release() {
            this.callBack = null;
            this.resultData = null;
        }
    }
}

