/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.core.channel.remote;

import android.app.ActivityManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.LruCache;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.transsion.aiservice.common.IInterfaceProxy;
import com.transsion.aiservice.common.ObjectBridge;
import com.transsion.aiservice.common.ObjectPoolManager;
import com.transsion.aiservice.common.RecyclerObj;
import com.transsion.aiservice.common.utils.AiLog;
import com.transsion.aiservice.oxygenbus.OxyGenBus;
import com.transsion.aiservice.oxygenbus.OxyGenThread;
import com.transsion.aiservice.oxygenbus.core.OxyGenBridge;
import com.transsion.aiservice.oxygenbus.core.OxyGenCallBack;
import com.transsion.aiservice.oxygenbus.core.ProcessAdapter;
import com.transsion.aiservice.oxygenbus.core.ResultDataManager;
import com.transsion.aiservice.oxygenbus.core.callback.CallBackCache;
import com.transsion.aiservice.oxygenbus.core.channel.BaseEvent;
import com.transsion.aiservice.oxygenbus.core.channel.CallBackTasker;
import com.transsion.aiservice.oxygenbus.core.channel.local.ReturnState;
import com.transsion.aiservice.oxygenbus.core.channel.remote.AiServiceLocalInterFace;
import com.transsion.aiservice.oxygenbus.core.channel.remote.RemoteChannel;
import com.transsion.aiservice.oxygenbus.core.channel.remote.RemoteProcess;
import com.transsion.aiservice.oxygenbus.core.trans.CommonTransData;
import com.transsion.aiservice.oxygenbus.core.trans.IOxyGenAidlInterface;
import com.transsion.aiservice.oxygenbus.datacover.DataParserManager;
import com.transsion.aiservice.oxygenbus.permission.LocalServicePermission;
import com.transsion.aiservice.oxygenbus.service.PluginServiceImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RemoteCallBackTasker
implements CallBackTasker<CommonTransData, CommonTransData> {
    private static final String TAG = "RemoteCallBackTasker";
    private static volatile RemoteCallBackTasker sRemoteCallBackTasker;
    private final LruCache<Integer, String> packageCache = new LruCache(10);
    private final Map<String, Listeners> registerCache = new ConcurrentHashMap<String, Listeners>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RemoteCallBackTasker getInstance() {
        if (sRemoteCallBackTasker != null) return sRemoteCallBackTasker;
        Class<RemoteCallBackTasker> clazz = RemoteCallBackTasker.class;
        synchronized (RemoteCallBackTasker.class) {
            if (sRemoteCallBackTasker != null) return sRemoteCallBackTasker;
            sRemoteCallBackTasker = new RemoteCallBackTasker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sRemoteCallBackTasker;
        }
    }

    @Override
    public void register(CommonTransData commonTransData, OxyGenCallBack callBack) {
        String packageName = this.getPackageNameFromUid(Binder.getCallingUid(), Binder.getCallingPid());
        String identification = CallBackCache.getRegisterIdentification(commonTransData.getServiceName(), commonTransData.getFunctionName());
        Listeners listeners = this.registerCache.get(identification);
        if (listeners == null) {
            listeners = ObjectPoolManager.getInstance().acquire(Listeners.class);
            this.registerCache.put(identification, listeners);
        }
        listeners.addPackage(packageName, commonTransData);
    }

    @Override
    public void onEvent(BaseEvent event) {
        CommonTransData commonTransData = null;
        switch (event.getType()) {
            case 100: {
                commonTransData = this.getCommonTransDataFromEvent(event);
                if (commonTransData == null) {
                    return;
                }
                this.requestInLocal(commonTransData, true);
                break;
            }
            case 105: {
                commonTransData = this.getCommonTransDataFromEvent(event);
                if (commonTransData == null) {
                    return;
                }
                this.requestInLocal(commonTransData, false);
                break;
            }
            case 101: {
                commonTransData = this.getCommonTransDataFromEvent(event);
                if (commonTransData == null) {
                    return;
                }
                this.register(commonTransData, (OxyGenCallBack)null);
                break;
            }
            case 102: {
                commonTransData = this.getCommonTransDataFromEvent(event);
                if (commonTransData == null) {
                    return;
                }
                this.unregister(commonTransData, (OxyGenCallBack)null);
                break;
            }
            case 106: {
                int pid = Binder.getCallingPid();
                if (pid == 0 && (commonTransData = this.getCommonTransDataFromEvent(event)) != null) {
                    pid = commonTransData.getPid();
                }
                RemoteChannel.addClientRemoteBinder(this.getPackageNameFromUid(Binder.getCallingUid(), pid), (IOxyGenAidlInterface)event.getObject());
                break;
            }
            default: {
                CallBackTasker.super.onEvent(event);
            }
        }
    }

    @Nullable
    private CommonTransData getCommonTransDataFromEvent(BaseEvent event) {
        CommonTransData commonTransData = (CommonTransData)event.getObject();
        int pid = Binder.getCallingPid();
        if (pid == 0) {
            pid = commonTransData.getPid();
        }
        String packageName = this.getPackageNameFromUid(Binder.getCallingUid(), pid);
        commonTransData.setClientPackageName(packageName);
        if (!LocalServicePermission.getInstance().allow(commonTransData)) {
            this.postErrInRemote(commonTransData, "no Permission in " + commonTransData.getServiceName());
            return null;
        }
        return commonTransData;
    }

    private void requestInLocal(CommonTransData data, boolean needCallBack) {
        int mCallBack = data.getCallbackHashCode();
        String packageName = data.getClientPackageName();
        OxyGenThread.getMsgHandler().post(() -> {
            ProcessAdapter processAdapter = OxyGenBridge.getInstance().getAddressProcess(1);
            Object result = null;
            try {
                result = OxyGenBridge.getInstance().request(processAdapter, data);
                if (result == ReturnState.ONE_WAY) {
                    return;
                }
                if (needCallBack) {
                    CommonTransData commonResultTransData = ResultDataManager.getResultData(result);
                    commonResultTransData.setClientPackageName(packageName);
                    commonResultTransData.setCallbackHashCode(mCallBack);
                    commonResultTransData.setActionType(103);
                    this.onResponse(commonResultTransData);
                }
            }
            catch (Exception e) {
                this.postErrInRemote(this.getRemoteErr(e.getMessage(), packageName, mCallBack));
            }
            finally {
                data.release();
            }
        });
    }

    public void postErrInRemote(CommonTransData err) {
        this.onResponse(err);
    }

    public void postErrInRemote(CommonTransData data, String errMsg) {
        this.postErrInRemote(this.getRemoteErr(errMsg, data.getClientPackageName(), data.getCallbackHashCode()));
    }

    public CommonTransData getRemoteErr(String err, String packageName, int callBackCode) {
        CommonTransData result = ResultDataManager.getResultData(err);
        result.setActionType(110);
        result.setClientPackageName(packageName);
        result.setCallbackHashCode(callBackCode);
        return result;
    }

    @Override
    public boolean unregister(CommonTransData data, OxyGenCallBack callBack) {
        return false;
    }

    private String getPackageNameFromUid(int uid, int pid) {
        RemoteProcess remoteProcess;
        String clientPackageName = this.getPackageNameFromUidInNative(uid, pid);
        if (TextUtils.isEmpty((CharSequence)clientPackageName) && (remoteProcess = (RemoteProcess)OxyGenBridge.getInstance().getAddressProcess(2)).getAiService().isConnected()) {
            try {
                clientPackageName = remoteProcess.getAiService().getInterface().getPackageNameFromUid(uid, pid);
                if (!TextUtils.isEmpty((CharSequence)clientPackageName)) {
                    this.packageCache.put((Object)uid, (Object)clientPackageName);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return clientPackageName;
    }

    public String getPackageNameFromUidInNative(int uid, int pid) {
        String clientPackageName = (String)this.packageCache.get((Object)uid);
        if (TextUtils.isEmpty((CharSequence)clientPackageName)) {
            String processName;
            String[] packages = OxyGenBus.getApplication().getPackageManager().getPackagesForUid(uid);
            if (packages == null) {
                return "";
            }
            if (packages.length == 1) {
                clientPackageName = packages[0];
            } else if (packages.length > 1 && !TextUtils.isEmpty((CharSequence)(processName = this.getProcessNameFromPid(pid)))) {
                for (String packageName : packages) {
                    if (!processName.contains(packageName)) continue;
                    clientPackageName = packageName;
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)clientPackageName)) {
            this.packageCache.put((Object)uid, (Object)clientPackageName);
        }
        return clientPackageName;
    }

    private String getProcessNameFromPid(int pid) {
        String processName = "";
        ActivityManager am = (ActivityManager)OxyGenBus.getApplication().getSystemService("activity");
        List l = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo info : l) {
            try {
                AiLog.e("===================", info.processName + ":pid:" + info.pid + ":uid:" + info.uid);
                if (info.pid != pid) continue;
                processName = info.processName;
                break;
            }
            catch (Exception exception) {
            }
        }
        return processName;
    }

    @Override
    public void onResponse(CommonTransData result) {
        if (result == null || TextUtils.isEmpty((CharSequence)result.getClientPackageName())) {
            AiLog.w(TAG, "callBackClient data is null");
            return;
        }
        AiLog.w(TAG, "callBackClient current packageName=" + result.getClientPackageName());
        IInterfaceProxy<IOxyGenAidlInterface> interfaceProxy = RemoteCallBackTasker.getCallBackBinder(result.getClientPackageName());
        if (interfaceProxy != null && interfaceProxy.isConnected()) {
            try {
                DataParserManager.getInstance().write(result.getParams(), result);
                AiLog.d(TAG, "callBackClient Target true process:" + interfaceProxy.getInterface().getProcessName());
                interfaceProxy.getInterface().asyncRequest(result);
                result.release();
            }
            catch (RemoteException e) {
                AiLog.e(TAG, "callBackClient err:" + (Object)((Object)e));
            }
        } else {
            AiLog.e(TAG, "not find remote CallBack in:" + result.getClientPackageName());
        }
    }

    private static IInterfaceProxy<IOxyGenAidlInterface> getCallBackBinder(String packageName) {
        AiServiceLocalInterFace localInterFace = ObjectBridge.get(AiServiceLocalInterFace.class);
        IInterfaceProxy<IOxyGenAidlInterface> interfaceProxy = localInterFace != null ? localInterFace.getClientBinder(packageName) : RemoteChannel.getRemoteBinderFromCache(packageName);
        if (interfaceProxy == null || !interfaceProxy.isConnected()) {
            RemoteProcess remoteProcess = (RemoteProcess)OxyGenBridge.getInstance().getAddressProcess(2);
            IInterfaceProxy<IOxyGenAidlInterface> aiService = remoteProcess.getAiService();
            if (aiService != null && aiService.isConnected()) {
                try {
                    IBinder binder = aiService.getInterface().getRemoteServer(301, packageName);
                    if (binder != null) {
                        interfaceProxy = new IInterfaceProxy<IOxyGenAidlInterface>().bindInterface(IOxyGenAidlInterface.Stub.asInterface(binder));
                    }
                }
                catch (RemoteException e) {
                    AiLog.e(TAG, "getCallBackBinder :err:" + (Object)((Object)e));
                }
            }
            if (interfaceProxy != null && interfaceProxy.isConnected()) {
                RemoteChannel.addClientRemoteBinder(packageName, interfaceProxy.getInterface());
            }
        }
        return interfaceProxy;
    }

    @Override
    public void saveCallBack(CommonTransData data, OxyGenCallBack callBack) {
    }

    @Override
    public void onBroadcast(CommonTransData result) {
        Listeners listeners = this.registerCache.get(result.getRegisterTarget());
        if (listeners != null && !listeners.isEmpty()) {
            try {
                listeners.dispatch(result);
            }
            catch (RemoteException e) {
                AiLog.w(TAG, "notifyData err:" + (Object)((Object)e));
            }
        }
    }

    @Override
    public void onErr(CommonTransData result) {
        this.onResponse(result);
    }

    public static class Listeners
    implements RecyclerObj {
        private final Set<Pair<String, CommonTransData>> packages = new HashSet<Pair<String, CommonTransData>>();

        public synchronized void addPackage(String packageName, CommonTransData commonTransData) {
            this.packages.add((Pair<String, CommonTransData>)new Pair((Object)packageName, (Object)commonTransData));
        }

        public void dispatch(CommonTransData commonResultTransData) throws RemoteException {
            for (Pair<String, CommonTransData> pair : this.packages) {
                IInterfaceProxy interfaceProxy;
                String packageName = (String)pair.first;
                CommonTransData observerData = (CommonTransData)pair.second;
                if (observerData != null && !observerData.isRelease() && observerData.getTag() != null && observerData.getTag() instanceof PluginServiceImpl && !this.filterObserver((PluginServiceImpl)observerData.getTag(), commonResultTransData) || (interfaceProxy = RemoteCallBackTasker.getCallBackBinder(packageName)) == null || !interfaceProxy.isConnected()) continue;
                ((IOxyGenAidlInterface)interfaceProxy.getInterface()).asyncRequest(commonResultTransData);
            }
        }

        private boolean filterObserver(PluginServiceImpl pluginService, CommonTransData commonTransData) {
            return pluginService.filterObserver(commonTransData);
        }

        public synchronized void removePackage(String identification) {
            this.packages.remove(identification);
        }

        public synchronized boolean isEmpty() {
            return this.packages.isEmpty();
        }

        @Override
        public boolean isRelease() {
            return this.packages == null || this.packages.isEmpty();
        }

        @Override
        public void release() {
            this.packages.clear();
        }
    }
}

