/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.core.trans;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import com.google.gson.Gson;
import com.transsion.aiservice.common.ObjectPoolManager;
import com.transsion.aiservice.common.utils.AiLog;
import com.transsion.aiservice.oxygenbus.core.GsonTask;
import com.transsion.aiservice.oxygenbus.core.OxyGenBridge;
import com.transsion.aiservice.oxygenbus.core.callback.ResponseCallBack;
import com.transsion.aiservice.oxygenbus.core.trans.BaseTransData;
import com.transsion.aiservice.oxygenbus.core.trans.IOxyGenAidlInterface;
import com.transsion.aiservice.oxygenbus.datacover.BaseTypeParserAdapter;
import com.transsion.aiservice.oxygenbus.error.ExceptionManager;

public class CommonTransData
extends BaseTransData
implements Parcelable,
ResponseCallBack {
    public static final String KEY_ACTION_TYPE = "actionType";
    public static final String KEY_TRANS_TYPE = "transType";
    public static final String KEY_SERVICE_TYPE = "serviceType";
    public static final String KEY_SERVICE_NAME = "serviceName";
    public static final String KEY_FUNCTION_NAME = "functionName";
    public static final String KEY_CALLBACK_HASHCODE = "callbackHashCode";
    public static final String KEY_IS_CALLBACK_REQUEST = "IsCallBackRequest";
    public static final String KEY_REGISTER_TARGET = "registerTarget";
    public static final String KEY_REGISTER_BINDER = "registerBinder";
    public static final String KEY_REQUEST_TIMEOUT = "requestTimeout";
    public static final String KEY_PID = "pid";
    public static final String KEY_PARAMS = "params";
    public static final int DEFAULT_TRANS_TYPE = -67108864;
    public static final int DEFAULT_ACTION_TYPE = 100;
    public static final int DEFAULT_SERVICE_TYPE = -1;
    public static final int DEFAULT_CALLBACK_HASHCODE = 0;
    public static final long DEFAULT_REQUEST_TIMEOUT = 0L;
    private Bundle mBundle;
    private Object mParams;
    private String mClientPackageName;
    private volatile boolean mReleaseFlag = false;
    private Object tag;
    public static final Parcelable.Creator<CommonTransData> CREATOR = new Parcelable.Creator<CommonTransData>(){

        public CommonTransData createFromParcel(Parcel in) {
            CommonTransData commonTransData = ObjectPoolManager.getInstance().acquire(CommonTransData.class);
            return commonTransData.setParcel(in);
        }

        public CommonTransData[] newArray(int size) {
            return new CommonTransData[size];
        }
    };

    protected CommonTransData(Parcel in) {
        this.setParcel(in);
    }

    protected CommonTransData setParcel(Parcel in) {
        this.mBundle = in.readBundle(this.getClass().getClassLoader());
        int mTransType = this.mBundle.getInt(KEY_TRANS_TYPE, -67108864);
        this.readParams(mTransType);
        return this;
    }

    private void readParams(int transType) {
        switch (transType) {
            case 16: {
                this.mParams = this.mBundle.getParcelable(KEY_PARAMS);
                break;
            }
            case 48: {
                this.mParams = this.mBundle.getBinder(KEY_PARAMS);
                break;
            }
            case 32: {
                this.mParams = this.mBundle.getString(KEY_PARAMS);
                break;
            }
        }
    }

    private void writeParams() {
        int transType = this.getTransType();
        this.mBundle.putInt(KEY_TRANS_TYPE, transType);
        if (this.mParams instanceof BaseTypeParserAdapter.ParcelableBaseType) {
            this.mBundle.putInt(KEY_TRANS_TYPE, 96);
            this.mBundle.putParcelable(KEY_PARAMS, (Parcelable)this.mParams);
        } else if (this.mParams instanceof Parcelable) {
            this.mBundle.putInt(KEY_TRANS_TYPE, 16);
            this.mBundle.putParcelable(KEY_PARAMS, (Parcelable)this.mParams);
        } else if (this.mParams instanceof Binder) {
            this.mBundle.putInt(KEY_TRANS_TYPE, 48);
            this.mBundle.putBinder(KEY_PARAMS, (IBinder)this.mParams);
        } else if (this.mParams instanceof String) {
            this.mBundle.putInt(KEY_TRANS_TYPE, 32);
            this.mBundle.putString(KEY_PARAMS, (String)this.mParams);
        } else {
            this.mBundle.putInt(KEY_TRANS_TYPE, -67108864);
        }
        this.mBundle.putInt(KEY_PID, Process.myPid());
    }

    public void writeToParcel(Parcel dest, int flags) {
        this.writeParams();
        dest.writeBundle(this.mBundle);
        if (this.mReleaseFlag) {
            AiLog.i("CommonTransData", "release In objectPool");
            this.release();
        }
    }

    @Override
    public int getCallbackHashCode() {
        return this.mBundle.getInt(KEY_CALLBACK_HASHCODE, 0);
    }

    public int getPid() {
        return this.mBundle.getInt(KEY_PID, 0);
    }

    public Object getTag() {
        return this.tag;
    }

    public CommonTransData setTag(Object tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public void setCallbackHashCode(int callbackHashCode) {
        this.mBundle.putInt(KEY_CALLBACK_HASHCODE, callbackHashCode);
        this.setCallBackRequest(true);
    }

    public void setRequestTimeout(long timeout) {
        this.mBundle.putLong(KEY_REQUEST_TIMEOUT, timeout);
    }

    public long getRequestTimeout() {
        return this.mBundle.getLong(KEY_REQUEST_TIMEOUT, 0L);
    }

    @Override
    public int getActionType() {
        return this.mBundle.getInt(KEY_ACTION_TYPE, 100);
    }

    @Override
    public void setActionType(int actionType) {
        this.mBundle.putInt(KEY_ACTION_TYPE, actionType);
    }

    public void setCallBackRequest(boolean isCallBackRequest) {
        this.mBundle.putBoolean(KEY_IS_CALLBACK_REQUEST, isCallBackRequest);
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public Gson getGson() {
        return GsonTask.getGson();
    }

    @Override
    public int getServiceType() {
        return this.mBundle.getInt(KEY_SERVICE_TYPE, -1);
    }

    public CommonTransData setServiceType(int serviceType) {
        this.mBundle.putInt(KEY_SERVICE_TYPE, serviceType);
        return this;
    }

    public CommonTransData releaseInParcel() {
        this.mReleaseFlag = true;
        return this;
    }

    public CommonTransData setData(String serviceName, String funName, Object paramObj, int actionType, long timeOut) {
        this.mParams = paramObj;
        this.setServiceName(serviceName);
        this.setActionType(actionType);
        this.setFunctionName(funName);
        this.setRequestTimeout(timeOut);
        return this;
    }

    public Parcelable getParcelableData() {
        if (this.mParams instanceof Parcelable) {
            return (Parcelable)this.mParams;
        }
        return null;
    }

    public void setParcelableData(Parcelable parcelableData) {
        this.mParams = parcelableData;
    }

    public IBinder getBinder() {
        if (this.mParams instanceof IBinder) {
            return (IBinder)this.mParams;
        }
        return null;
    }

    public void setBinder(IBinder binder) {
        this.mParams = binder;
    }

    public static CommonTransData get() {
        return ObjectPoolManager.getInstance().acquire(CommonTransData.class);
    }

    public CommonTransData() {
        this.mBundle = new Bundle();
    }

    @Override
    public boolean isCallBackRequest() {
        return this.mBundle.getInt(KEY_CALLBACK_HASHCODE, 0) != 0 && this.mBundle.getBoolean(KEY_IS_CALLBACK_REQUEST, false);
    }

    public String getClientPackageName() {
        return this.mClientPackageName;
    }

    public void setClientPackageName(String clientPackageName) {
        this.mClientPackageName = clientPackageName;
    }

    @Override
    public String getServiceName() {
        return this.mBundle.getString(KEY_SERVICE_NAME);
    }

    public void setServiceName(String serviceName) {
        this.mBundle.putString(KEY_SERVICE_NAME, serviceName);
    }

    @Override
    public String getFunctionName() {
        return this.mBundle.getString(KEY_FUNCTION_NAME);
    }

    public void setFunctionName(String functionName) {
        this.mBundle.putString(KEY_FUNCTION_NAME, functionName);
    }

    public String getStringParam() {
        return (String)this.mParams;
    }

    public void setStringParam(String param) {
        this.mParams = param;
    }

    @Override
    public void setTransType(int transType) {
        this.mBundle.putInt(KEY_TRANS_TYPE, transType);
    }

    @Override
    public void setParams(Object obj) {
        this.mParams = obj;
    }

    @Override
    public Object getParams() {
        if (this.mParams == null) {
            this.mParams = this.mBundle.get(KEY_PARAMS);
        }
        return this.mParams;
    }

    @Override
    public boolean isRelease() {
        return this.mBundle.isEmpty();
    }

    public boolean haveBinder() {
        return this.mParams instanceof IBinder;
    }

    @Override
    public void release() {
    }

    @Override
    public int getTransType() {
        return this.mBundle.getInt(KEY_TRANS_TYPE, -67108864);
    }

    public String getRegisterTarget() {
        return this.mBundle.getString(KEY_REGISTER_TARGET);
    }

    public void setRegisterTarget(String registerIdentification) {
        this.mBundle.putString(KEY_REGISTER_TARGET, registerIdentification);
    }

    public void setRegisterBinder(IOxyGenAidlInterface currentClient) {
        this.mBundle.putBinder(KEY_REGISTER_BINDER, currentClient.asBinder());
    }

    public IBinder getRegisterBinder() {
        return this.mBundle.getBinder(KEY_REGISTER_BINDER);
    }

    public String toString() {
        return "CommonTransData{mBundle=" + this.mBundle + ", mParams=" + this.mParams + ", mClientPackageName='" + this.mClientPackageName + '\'' + ", mReleaseFlag=" + this.mReleaseFlag + '}';
    }

    public void throwClientError(Exception e) {
        ExceptionManager.getInstance().postError(this, e);
    }

    public void throwClientError(String errMessage) {
        this.setServiceType(1);
        ExceptionManager.getInstance().postError(this, errMessage);
    }

    public void throwServerError(String errMessage) {
        ExceptionManager.getInstance().postError(this, errMessage);
    }

    @Override
    public void call(Object obj) {
        OxyGenBridge.getInstance().getCallBackController().sendCallBack(this, obj);
    }

    public ResponseCallBack getClientCallBack() {
        return this;
    }
}

