/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.core.trans;

import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.transsion.aiservice.common.ObjectPoolManager;
import com.transsion.aiservice.common.utils.AiLog;
import com.transsion.aiservice.oxygenbus.core.GsonTask;
import com.transsion.aiservice.oxygenbus.core.trans.BaseTransData;

public class CommonTransDataBack
extends BaseTransData
implements Parcelable {
    private int mActionType = 100;
    private int mServiceType = 1;
    private String mServiceName;
    private String mFunctionName;
    private int mTransType = -67108864;
    private int mCallbackHashCode = 0;
    private boolean mIsCallBackRequest;
    private volatile boolean mReleaseFlag = false;
    private Object mParams;
    private String mClientPackageName;
    private String mRegisterTarget;
    public static final Parcelable.Creator<CommonTransDataBack> CREATOR = new Parcelable.Creator<CommonTransDataBack>(){

        public CommonTransDataBack createFromParcel(Parcel in) {
            CommonTransDataBack commonTransData = ObjectPoolManager.getInstance().acquire(CommonTransDataBack.class);
            return commonTransData.setParcel(in);
        }

        public CommonTransDataBack[] newArray(int size) {
            return new CommonTransDataBack[size];
        }
    };

    protected CommonTransDataBack(Parcel in) {
        this.setParcel(in);
    }

    protected CommonTransDataBack setParcel(Parcel in) {
        this.mServiceType = in.readInt();
        this.mTransType = in.readInt();
        this.readParams(this.mTransType, in);
        this.mServiceName = in.readString();
        this.mFunctionName = in.readString();
        this.mCallbackHashCode = in.readInt();
        this.mActionType = in.readInt();
        this.mIsCallBackRequest = in.readBoolean();
        this.mRegisterTarget = in.readString();
        return this;
    }

    private void readParams(int transType, Parcel in) {
        switch (transType) {
            case 16: {
                this.mParams = in.readParcelable(CommonTransDataBack.class.getClassLoader());
                break;
            }
            case 48: {
                this.mParams = in.readStrongBinder();
                break;
            }
            case 32: {
                this.mParams = in.readString();
                break;
            }
        }
    }

    private void writeParams(Parcel dest) {
        this.mTransType = -67108864;
        if (this.mParams instanceof Parcelable) {
            this.mTransType = 16;
            dest.writeInt(this.mTransType);
            dest.writeParcelable((Parcelable)this.mParams, 1);
        } else if (this.mParams instanceof Binder) {
            this.mTransType = 48;
            dest.writeInt(this.mTransType);
            dest.writeStrongBinder((IBinder)this.mParams);
        } else if (this.mParams instanceof String) {
            this.mTransType = 32;
            dest.writeInt(this.mTransType);
            dest.writeString((String)this.mParams);
        } else {
            this.mTransType = -67108864;
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mServiceType);
        dest.writeInt(this.mTransType);
        this.writeParams(dest);
        dest.writeString(this.mServiceName);
        dest.writeString(this.mFunctionName);
        dest.writeInt(this.mCallbackHashCode);
        dest.writeInt(this.mActionType);
        dest.writeBoolean(this.mIsCallBackRequest);
        dest.writeString(this.mRegisterTarget);
        if (this.mReleaseFlag) {
            AiLog.i("CommonTransData", "release In objectPool");
            this.release();
        }
    }

    @Override
    public int getCallbackHashCode() {
        return this.mCallbackHashCode;
    }

    @Override
    public void setCallbackHashCode(int callbackHashCode) {
        this.mCallbackHashCode = callbackHashCode;
        this.mIsCallBackRequest = true;
    }

    @Override
    public int getActionType() {
        return this.mActionType;
    }

    @Override
    public void setActionType(int actionType) {
        this.mActionType = actionType;
    }

    public void setCallBackRequest(boolean callBackRequest) {
        this.mIsCallBackRequest = callBackRequest;
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public Gson getGson() {
        return GsonTask.getGson();
    }

    @Override
    public int getServiceType() {
        return this.mServiceType;
    }

    public CommonTransDataBack setServiceType(int serviceType) {
        this.mServiceType = serviceType;
        return this;
    }

    public CommonTransDataBack releaseInParcel() {
        this.mReleaseFlag = true;
        return this;
    }

    public CommonTransDataBack setData(String module, String funName, Object paramObj, int actionType) {
        this.mParams = paramObj;
        this.mServiceName = module;
        this.mFunctionName = funName;
        this.mActionType = actionType;
        return this;
    }

    public Parcelable getParcelableData() {
        if (this.mParams instanceof Parcelable) {
            return (Parcelable)this.mParams;
        }
        return null;
    }

    public void setParcelableData(Parcelable parcelableData) {
        this.mParams = parcelableData;
    }

    public IBinder getBinder() {
        if (this.mParams instanceof IBinder) {
            return (IBinder)this.mParams;
        }
        return null;
    }

    public void setBinder(IBinder binder) {
        this.mParams = binder;
    }

    public static CommonTransDataBack get() {
        return ObjectPoolManager.getInstance().acquire(CommonTransDataBack.class);
    }

    public CommonTransDataBack() {
    }

    @Override
    public boolean isCallBackRequest() {
        return this.mCallbackHashCode != 0 && this.mIsCallBackRequest;
    }

    public String getClientPackageName() {
        return this.mClientPackageName;
    }

    public void setClientPackageName(String clientPackageName) {
        this.mClientPackageName = clientPackageName;
    }

    @Override
    public String getServiceName() {
        return this.mServiceName;
    }

    public void setServiceName(String serviceName) {
        this.mServiceName = serviceName;
    }

    @Override
    public String getFunctionName() {
        return this.mFunctionName;
    }

    public void setFunctionName(String functionName) {
        this.mFunctionName = functionName;
    }

    public String getStringParam() {
        return (String)this.mParams;
    }

    public void setStringParam(String param) {
        this.mParams = param;
    }

    @Override
    public void setTransType(int transType) {
        this.mTransType = transType;
    }

    @Override
    public void setParams(Object obj) {
        this.mParams = obj;
    }

    @Override
    public Object getParams() {
        return this.mParams;
    }

    @Override
    public boolean isRelease() {
        return TextUtils.isEmpty((CharSequence)this.mServiceName) && TextUtils.isEmpty((CharSequence)this.mFunctionName);
    }

    public boolean haveBinder() {
        return this.mParams instanceof IBinder;
    }

    @Override
    public void release() {
        this.mServiceName = null;
        this.mFunctionName = null;
        this.mReleaseFlag = false;
        this.mServiceType = -67108864;
        this.mCallbackHashCode = 0;
        this.mIsCallBackRequest = false;
        ObjectPoolManager.getInstance().release(this);
    }

    @Override
    public int getTransType() {
        return this.mTransType;
    }

    public String getRegisterTarget() {
        return this.mRegisterTarget;
    }

    public void setRegisterTarget(String registerIdentification) {
        this.mRegisterTarget = registerIdentification;
    }
}

