/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.core.trans;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.transsion.aiservice.oxygenbus.core.trans.CommonTransData;

public interface IOxyGenAidlInterface
extends IInterface {
    public CommonTransData syncRequest(CommonTransData var1) throws RemoteException;

    public IBinder getRemoteServer(int var1, String var2) throws RemoteException;

    public void asyncRequest(CommonTransData var1) throws RemoteException;

    public String getPackageNameFromUid(int var1, int var2) throws RemoteException;

    public String getProcessName() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOxyGenAidlInterface {
        private static final String DESCRIPTOR = "com.transsion.aiservice.oxygenbus.core.trans.IOxyGenAidlInterface";
        static final int TRANSACTION_syncRequest = 1;
        static final int TRANSACTION_getRemoteServer = 2;
        static final int TRANSACTION_asyncRequest = 3;
        static final int TRANSACTION_getPackageNameFromUid = 4;
        static final int TRANSACTION_getProcessName = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IOxyGenAidlInterface asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IOxyGenAidlInterface) {
                return (IOxyGenAidlInterface)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    CommonTransData _arg0 = 0 != data.readInt() ? (CommonTransData)CommonTransData.CREATOR.createFromParcel(data) : null;
                    CommonTransData _result = this.syncRequest(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IBinder _result = this.getRemoteServer(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    CommonTransData _arg0 = 0 != data.readInt() ? (CommonTransData)CommonTransData.CREATOR.createFromParcel(data) : null;
                    this.asyncRequest(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _result = this.getPackageNameFromUid(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _result = this.getProcessName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IOxyGenAidlInterface impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IOxyGenAidlInterface getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IOxyGenAidlInterface {
            private IBinder mRemote;
            public static IOxyGenAidlInterface sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommonTransData syncRequest(CommonTransData data) throws RemoteException {
                CommonTransData _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CommonTransData commonTransData = Stub.getDefaultImpl().syncRequest(data);
                        return commonTransData;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (CommonTransData)CommonTransData.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder getRemoteServer(int type, String module) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeString(module);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IBinder iBinder = Stub.getDefaultImpl().getRemoteServer(type, module);
                        return iBinder;
                    }
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void asyncRequest(CommonTransData data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().asyncRequest(data);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPackageNameFromUid(int uid, int pid) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(pid);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string = Stub.getDefaultImpl().getPackageNameFromUid(uid, pid);
                        return string;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getProcessName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string = Stub.getDefaultImpl().getProcessName();
                        return string;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IOxyGenAidlInterface {
        @Override
        public CommonTransData syncRequest(CommonTransData data) throws RemoteException {
            return null;
        }

        @Override
        public IBinder getRemoteServer(int type, String module) throws RemoteException {
            return null;
        }

        @Override
        public void asyncRequest(CommonTransData data) throws RemoteException {
        }

        @Override
        public String getPackageNameFromUid(int uid, int pid) throws RemoteException {
            return null;
        }

        @Override
        public String getProcessName() throws RemoteException {
            return null;
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

