/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.datacover;

import android.os.Parcel;
import android.os.Parcelable;
import com.transsion.aiservice.common.ObjectPoolManager;
import com.transsion.aiservice.oxygenbus.BaseRecyclerObjImpl;
import com.transsion.aiservice.oxygenbus.datacover.ParserAdapterInterface;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

public class BaseTypeParserAdapter
implements ParserAdapterInterface<Parcelable, Parcelable> {
    private final List<Class> mBaseType = Arrays.asList(Integer.TYPE, Integer.class, Double.class, Double.TYPE, Float.TYPE, Float.class, String.class, Short.TYPE, Short.class, Boolean.TYPE, Boolean.class);

    @Override
    public Object read(Parcelable data, Type type) {
        if (data instanceof ParcelableBaseType) {
            Object result = ((ParcelableBaseType)data).getRawData();
            if (type instanceof Class && ((Class)type).isInstance(result)) {
                return result;
            }
            Object resultObj = null;
            if (type == String.class) {
                resultObj = result.toString();
            } else if (type == Integer.TYPE || type == Integer.class) {
                resultObj = Integer.parseInt(result.toString());
            } else if (type == Double.TYPE || type == Double.class) {
                resultObj = Double.parseDouble(result.toString());
            } else if (type == Float.TYPE || type == Float.class) {
                resultObj = Float.valueOf(Float.parseFloat(result.toString()));
            } else if (type == Short.TYPE || type == Short.class) {
                resultObj = Short.parseShort(result.toString());
            } else if (type == Boolean.TYPE || type == Boolean.class) {
                resultObj = Boolean.parseBoolean(result.toString());
            }
            return resultObj;
        }
        return null;
    }

    @Override
    public Parcelable write(Object obj, Object ... objects) {
        return ParcelableBaseType.create(obj);
    }

    @Override
    public boolean isSupport(Object obj) {
        return this.isBaseType(obj);
    }

    private boolean isBaseType(Object object) {
        return this.mBaseType.contains(object.getClass());
    }

    public static class ParcelableBaseType
    extends BaseRecyclerObjImpl
    implements Parcelable {
        private Object obj;
        private int baseType;
        public static final Parcelable.Creator<ParcelableBaseType> CREATOR = new Parcelable.Creator<ParcelableBaseType>(){

            public ParcelableBaseType createFromParcel(Parcel in) {
                return ParcelableBaseType.create().setData(in);
            }

            public ParcelableBaseType[] newArray(int size) {
                return new ParcelableBaseType[size];
            }
        };

        public static ParcelableBaseType create() {
            return ObjectPoolManager.getInstance().acquire(ParcelableBaseType.class);
        }

        public static ParcelableBaseType create(Object obj) {
            ParcelableBaseType parcelableBaseType = ParcelableBaseType.create();
            parcelableBaseType.setObj(obj);
            return parcelableBaseType;
        }

        public ParcelableBaseType setObj(Object obj) {
            this.obj = obj;
            if (obj instanceof Integer) {
                this.baseType = 1;
            } else if (obj instanceof Double) {
                this.baseType = 2;
            } else if (obj instanceof Float) {
                this.baseType = 4;
            } else if (obj instanceof String) {
                this.baseType = 3;
            } else if (obj instanceof Short) {
                this.baseType = 5;
            } else if (obj instanceof Boolean) {
                this.baseType = 6;
            }
            return this;
        }

        public ParcelableBaseType setData(Parcel in) {
            this.baseType = in.readInt();
            switch (this.baseType) {
                case 1: {
                    this.obj = in.readInt();
                    break;
                }
                case 3: {
                    this.obj = in.readString();
                    break;
                }
                case 2: {
                    this.obj = in.readDouble();
                    break;
                }
                case 4: {
                    this.obj = Float.valueOf(in.readFloat());
                    break;
                }
                case 5: {
                    this.obj = in.readString();
                    this.obj = Short.parseShort(this.obj.toString());
                    break;
                }
                case 6: {
                    this.obj = in.readBoolean();
                    break;
                }
            }
            return this;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.baseType);
            switch (this.baseType) {
                case 3: {
                    dest.writeString((String)this.obj);
                    break;
                }
                case 1: {
                    dest.writeInt(((Integer)this.obj).intValue());
                    break;
                }
                case 2: {
                    dest.writeDouble(((Double)this.obj).doubleValue());
                    break;
                }
                case 4: {
                    dest.writeFloat(((Float)this.obj).floatValue());
                    break;
                }
                case 5: {
                    dest.writeString(String.valueOf(this.obj));
                    break;
                }
                case 6: {
                    dest.writeBoolean(((Boolean)this.obj).booleanValue());
                    break;
                }
                default: {
                    dest.writeString(this.obj.toString());
                }
            }
        }

        public Object getRawData() {
            return this.obj;
        }

        public int getBaseType() {
            return this.baseType;
        }

        @Override
        public boolean isRelease() {
            return this.obj == null;
        }

        @Override
        public void release() {
            this.obj = null;
            super.release();
        }
    }
}

