/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.datacover;

import android.text.TextUtils;
import com.transsion.aiservice.common.ObjectPoolManager;
import com.transsion.aiservice.common.RecyclerObj;
import com.transsion.aiservice.oxygenbus.build.OxyGenMap;
import com.transsion.aiservice.oxygenbus.build.ParcelableBuilder;
import com.transsion.aiservice.oxygenbus.core.callback.ResponseCallBack;
import com.transsion.aiservice.oxygenbus.core.trans.BaseTransData;
import com.transsion.aiservice.oxygenbus.core.trans.CommonTransData;
import com.transsion.aiservice.oxygenbus.datacover.BaseType;

public class OxyGenDataPackage<T>
extends BaseType<T>
implements RecyclerObj {
    private int mResultCode = 201;
    private String mErrorMessage;
    private T mResult;
    private BaseTransData mRawData;

    public static <T> OxyGenDataPackage<T> create(BaseTransData rawData, T obj) {
        OxyGenDataPackage result = ObjectPoolManager.getInstance().acquire(OxyGenDataPackage.class);
        result.mResult = obj;
        result.mRawData = rawData;
        return result;
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    public String getErrorMessage() {
        return TextUtils.isEmpty((CharSequence)this.mErrorMessage) ? String.valueOf(this.mResult) : this.mErrorMessage;
    }

    public void setResult(T mResult) {
        this.mResult = mResult;
    }

    public OxyGenDataPackage<T> setErrorMessage(String mErrorMessage) {
        this.mErrorMessage = mErrorMessage;
        return this;
    }

    public OxyGenDataPackage<T> setResultCode(int mResultCode) {
        this.mResultCode = mResultCode;
        return this;
    }

    public ResponseCallBack getClientCallBack() {
        if (this.mRawData != null) {
            return ((CommonTransData)this.mRawData).getClientCallBack();
        }
        return null;
    }

    public T getResult() {
        T result = this.mResult;
        this.mResult = null;
        return result;
    }

    public OxyGenMap getOxyGenMap() {
        Object params;
        if (this.mRawData != null && (params = ((CommonTransData)this.mResult).getParams()) instanceof ParcelableBuilder) {
            return ((ParcelableBuilder)params).getOxyGenMap();
        }
        return null;
    }

    public BaseTransData getRawData() {
        return this.mRawData;
    }

    @Override
    public boolean isRelease() {
        return this.mResult == null;
    }

    @Override
    public void release() {
        this.mResult = null;
        this.mRawData = null;
        this.mResultCode = 201;
        ObjectPoolManager.getInstance().release(this);
    }
}

