/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.service;

import android.text.TextUtils;
import com.transsion.aiservice.common.utils.AiLog;
import com.transsion.aiservice.oxygenbus.core.OxyGenBridge;
import com.transsion.aiservice.oxygenbus.core.ProcessAdapter;
import com.transsion.aiservice.oxygenbus.core.ann.OxyGenFunction;
import com.transsion.aiservice.oxygenbus.core.ann.OxyGenService;
import com.transsion.aiservice.oxygenbus.core.channel.local.WaiterHandler;
import com.transsion.aiservice.oxygenbus.datacover.DataParserManager;
import com.transsion.aiservice.oxygenbus.service.PluginServiceImpl;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class OxyGenServerHelper {
    private static final String TAG = "OxyGenServerHelper";

    public static boolean register(String clazzName, ClassLoader classLoader) {
        try {
            AiLog.i(TAG, "load class:" + clazzName);
            Class<?> clazz = classLoader.loadClass(clazzName);
            OxyGenServerHelper.register(clazz);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean register(Class<? extends PluginServiceImpl> clazz) {
        OxyGenService oxyGenService = clazz.getAnnotation(OxyGenService.class);
        if (oxyGenService == null) {
            AiLog.w("QxyGenServerHelper", clazz.getName() + ":register err");
            return false;
        }
        if (!OxyGenServerHelper.registerByType(clazz, 1, oxyGenService.name())) {
            return false;
        }
        if (oxyGenService.type() != 1) {
            return OxyGenServerHelper.registerByType(clazz, 1, oxyGenService.name());
        }
        return true;
    }

    private static boolean registerByType(Class<? extends PluginServiceImpl> clazz, int type, String serviceName) {
        Method[] methods;
        ProcessAdapter processAdapter = OxyGenBridge.getInstance().getAddressProcess(type);
        if (processAdapter == null) {
            return false;
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            OxyGenFunction function = method.getAnnotation(OxyGenFunction.class);
            if (function == null || TextUtils.isEmpty((CharSequence)function.name())) continue;
            Type functionParamType = OxyGenServerHelper.getParamType(method);
            processAdapter.register(serviceName, WaiterHandler.get(clazz, method.getName(), function.name(), functionParamType, Void.TYPE == method.getReturnType()));
        }
        return true;
    }

    private static Type getParamType(Method method) {
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        return DataParserManager.instanceActualTypeArguments(genericParameterTypes[0]);
    }

    public static boolean isLocalServer(String serviceName) {
        ProcessAdapter processAdapter = OxyGenBridge.getInstance().getAddressProcess(1);
        return processAdapter.isSupportModule(serviceName);
    }
}

