/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.common.utils;

import android.os.DeadSystemException;
import android.util.Log;
import com.transsion.aiservice.common.utils.AndroidHiddenApi;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;

public final class AiLog {
    public static final int A = 1;
    public static final int V = 2;
    public static final int D = 3;
    public static final int I = 4;
    public static final int W = 5;
    public static final int E = 6;
    public static final int LOG_ID_MAIN = 0;
    public static final int LOG_ID_RADIO = 1;
    public static final int LOG_ID_EVENTS = 2;
    public static final int LOG_ID_SYSTEM = 3;
    public static final int LOG_ID_CRASH = 4;
    private static final boolean sIsSystem = AndroidHiddenApi.ActivityThreadProxy.isSystem();
    private static final String TAG = "Kolun_AI";
    private static boolean sUseCommonTag = false;
    private static int sLogLevel = 1;
    private static Method sPrintlnNativeMethod;

    public static void setDebugLevel(int level, boolean useCommonTag) {
        sLogLevel = level;
        sUseCommonTag = useCommonTag;
    }

    public static void setDebugLevel(int level) {
        AiLog.setDebugLevel(level, false);
    }

    public static int v(String tag, String msg) {
        return AiLog.v(true, tag, msg);
    }

    public static int v(String tag, String msg, Throwable tr) {
        return AiLog.v(true, tag, msg, tr);
    }

    public static int d(String tag, String msg) {
        return AiLog.d(true, tag, msg);
    }

    public static int d(String tag, String msg, Throwable tr) {
        return AiLog.d(true, tag, msg, tr);
    }

    public static int i(String tag, String msg) {
        return AiLog.i(true, tag, msg);
    }

    public static int i(String tag, String msg, Throwable tr) {
        return AiLog.i(true, tag, msg, tr);
    }

    public static int w(String tag, String msg) {
        return AiLog.w(true, tag, msg);
    }

    public static int w(String tag, String msg, Throwable tr) {
        return AiLog.w(true, tag, msg, tr);
    }

    public static int w(String tag, Throwable tr) {
        return AiLog.w(true, tag, null, null);
    }

    public static int e(String tag, String msg) {
        return AiLog.e(true, tag, msg, null);
    }

    public static int e(String tag, String msg, Throwable tr) {
        return AiLog.e(true, tag, msg, tr);
    }

    public static int v(boolean enable, String tag, String msg) {
        return AiLog.v(enable, tag, msg, null);
    }

    public static int v(boolean enable, String tag, String msg, Throwable tr) {
        return enable ? AiLog.invoke(2, tag, msg, tr) : 0;
    }

    public static int d(boolean enable, String tag, String msg) {
        return AiLog.d(enable, tag, msg, null);
    }

    public static int d(boolean enable, String tag, String msg, Throwable tr) {
        return enable ? AiLog.invoke(3, tag, msg, tr) : 0;
    }

    public static int i(boolean enable, String tag, String msg) {
        return AiLog.i(enable, tag, msg, null);
    }

    public static int i(boolean enable, String tag, String msg, Throwable tr) {
        return enable ? AiLog.invoke(4, tag, msg, tr) : 0;
    }

    public static int w(boolean enable, String tag, String msg) {
        return AiLog.w(enable, tag, msg, null);
    }

    public static int w(boolean enable, String tag, String msg, Throwable tr) {
        return enable ? AiLog.invoke(5, tag, msg, tr) : 0;
    }

    public static int w(boolean enable, String tag, Throwable tr) {
        return AiLog.w(enable, tag, "", tr);
    }

    public static int e(boolean enable, String tag, String msg) {
        return AiLog.e(enable, tag, msg, null);
    }

    public static int e(boolean enable, String tag, String msg, Throwable tr) {
        return enable ? AiLog.invoke(6, tag, msg, tr) : 0;
    }

    private static int invoke(int level, String tag, String msg, Throwable tr) {
        if (level > sLogLevel) {
            String realMessage;
            String realTag;
            if (sUseCommonTag) {
                realTag = TAG;
                realMessage = tag + ":" + msg;
            } else {
                realTag = TAG + "." + tag;
                realMessage = msg;
            }
            if (tr != null) {
                realMessage = realMessage + "\n" + AiLog.getStackTraceString(tr);
            }
            if (sPrintlnNativeMethod == null) {
                return Log.println((int)level, (String)realTag, (String)realMessage);
            }
            try {
                return (Integer)sPrintlnNativeMethod.invoke(null, 3, level, realTag, realMessage);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    private static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (t instanceof UnknownHostException) {
                return "";
            }
            if (!(t instanceof DeadSystemException)) continue;
            return "SystemServer is Crash";
        }
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    static {
        if (sIsSystem) {
            try {
                Class<?> clasz = Class.forName("android.util.Log");
                sPrintlnNativeMethod = clasz.getDeclaredMethod("println_native", Integer.TYPE, Integer.TYPE, String.class, String.class);
                sPrintlnNativeMethod.setAccessible(true);
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
    }
}

