/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.common.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.IBinder;
import com.transsion.aiservice.common.utils.AiLog;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AndroidHiddenApi {
    private static final String TAG = "AndroidHiddenApi";

    public static Object getInstance(String className, Class[] classes, Object[] params) throws IllegalArgumentException {
        if (className == null) {
            throw new IllegalArgumentException("class name must not null");
        }
        try {
            return AndroidHiddenApi.getInstance(Class.forName(className), classes, params);
        }
        catch (ClassNotFoundException e) {
            AiLog.w(TAG, "Warning : invoke getInstance, " + e);
        }
        catch (Exception e) {
            AiLog.w(TAG, "Warning : invoke getInstance ", (Throwable)e);
        }
        return null;
    }

    public static Object getInstance(Class<?> clasz, Class[] classes, Object[] params) throws IllegalArgumentException {
        if (clasz == null) {
            throw new IllegalArgumentException("class must not null");
        }
        try {
            Constructor<?> constructor = clasz.getDeclaredConstructor(classes);
            constructor.setAccessible(true);
            return constructor.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            AiLog.w(TAG, "Warning : invoke getInstance, " + e);
        }
        catch (Exception e) {
            AiLog.w(TAG, "Warning : invoke getInstance ", (Throwable)e);
        }
        return null;
    }

    public static Object invoke(String className, Object instance, String methodName, Object ... params) throws IllegalArgumentException {
        if (className == null) {
            throw new IllegalArgumentException("class name must not null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("method name must not null");
        }
        try {
            Class<?> c = Class.forName(className);
            return AndroidHiddenApi.invoke(Class.forName(className), instance, methodName, params);
        }
        catch (ClassNotFoundException e) {
            AiLog.w(TAG, "Warning : invoke  " + methodName + ", " + e);
        }
        catch (Exception e) {
            AiLog.w(TAG, "Warning : invoke  " + methodName + ", " + e);
        }
        return null;
    }

    public static Object invoke(Class<?> clasz, Object instance, String methodName, Object ... params) throws IllegalArgumentException {
        if (clasz == null) {
            throw new IllegalArgumentException("class  must not null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("method name must not null");
        }
        try {
            Class[] paramsTypes = null;
            if (params != null) {
                paramsTypes = new Class[params.length];
                for (int i = 0; i < params.length; ++i) {
                    paramsTypes[i] = params[i].getClass();
                }
            }
            Method method = clasz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method.invoke(instance, params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            AiLog.w(TAG, "Warning : invoke  " + methodName + ", " + e);
        }
        catch (Exception e) {
            AiLog.w(TAG, "Warning : invoke  " + methodName + ", " + e);
        }
        return null;
    }

    public static class SystemPropertiesProxy {
        private static Class<?> sClass = null;
        private static Method sGetLongMethod = null;
        private static Method sGetIntMethod = null;
        private static Method sGetBooleanMethod = null;
        private static Method sGetStringMethod = null;

        public static boolean getBoolean(String key, boolean def) {
            try {
                if (sClass == null) {
                    sClass = Class.forName("android.os.SystemProperties");
                }
                if (sGetBooleanMethod == null) {
                    sGetBooleanMethod = sClass.getDeclaredMethod("getBoolean", String.class, Boolean.TYPE);
                    sGetBooleanMethod.setAccessible(true);
                }
                return (Boolean)sGetBooleanMethod.invoke(null, key, def);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                AiLog.w(AndroidHiddenApi.TAG, "Warning : invoke SystemProperties.getBoolean, " + e);
                return def;
            }
        }

        public static int getInt(String key, int def) {
            try {
                if (sClass == null) {
                    sClass = Class.forName("android.os.SystemProperties");
                }
                if (sGetIntMethod == null) {
                    sGetIntMethod = sClass.getDeclaredMethod("getInt", String.class, Integer.TYPE);
                    sGetIntMethod.setAccessible(true);
                }
                return (Integer)sGetIntMethod.invoke(null, key, def);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                AiLog.w(AndroidHiddenApi.TAG, "Warning : invoke SystemProperties.getInt, " + e);
                return def;
            }
        }

        @SuppressLint(value={"PrivateApi"})
        public static String getString(String key, String def) {
            try {
                if (sClass == null) {
                    sClass = Class.forName("android.os.SystemProperties");
                }
                if (sGetStringMethod == null) {
                    sGetStringMethod = sClass.getDeclaredMethod("get", String.class, String.class);
                    sGetStringMethod.setAccessible(true);
                }
                return (String)sGetStringMethod.invoke(null, key, def);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                AiLog.w(AndroidHiddenApi.TAG, "Warning : invoke SystemProperties.getString, " + e);
                return def;
            }
        }

        public static long getLong(String key, long def) {
            try {
                if (sClass == null) {
                    sClass = Class.forName("android.os.SystemProperties");
                }
                if (sGetLongMethod == null) {
                    sGetLongMethod = sClass.getDeclaredMethod("getLong", String.class, String.class);
                    sGetLongMethod.setAccessible(true);
                }
                return (Long)sGetLongMethod.invoke(null, key, def);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                AiLog.w(AndroidHiddenApi.TAG, "Warning : invoke SystemProperties.getLong, " + e);
                return def;
            }
        }
    }

    public static class EnvironmentProxy {
        private static Class<?> sClass = null;
        private static Method sGetDataSystemDirectory = null;

        public static File getDataServiceDirectory(Context context) {
            return context.getCacheDir();
        }

        public static File getDataSystemDirectory() {
            try {
                if (sClass == null) {
                    sClass = Class.forName("android.os.Environment");
                }
                if (sGetDataSystemDirectory == null) {
                    sGetDataSystemDirectory = sClass.getDeclaredMethod("getDataSystemDirectory", new Class[0]);
                    sGetDataSystemDirectory.setAccessible(true);
                }
                return (File)sGetDataSystemDirectory.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                AiLog.w(AndroidHiddenApi.TAG, "Warning : invoke Environment.getDataSystemDirectory, " + e);
                return null;
            }
        }
    }

    public static class ActivityThreadProxy {
        private static Class<?> sClass = null;
        private static Method sIsSystemMethod = null;

        public static boolean isAiService() {
            return true;
        }

        public static boolean isSystem() {
            try {
                if (sClass == null) {
                    sClass = Class.forName("android.app.ActivityThread");
                }
                if (sIsSystemMethod == null) {
                    sIsSystemMethod = sClass.getDeclaredMethod("isSystem", new Class[0]);
                    sIsSystemMethod.setAccessible(true);
                }
                return (Boolean)sIsSystemMethod.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                AiLog.w(AndroidHiddenApi.TAG, "Warning : invoke ActivityThread.isSystem, " + e);
                return false;
            }
        }
    }

    public static class ServiceManagerProxy {
        private static Class<?> sClass = null;
        private static Method sGetServiceMethod = null;

        public static IBinder getService(String name) {
            try {
                if (sClass == null) {
                    sClass = Class.forName("android.os.ServiceManager");
                }
                if (sGetServiceMethod == null) {
                    sGetServiceMethod = sClass.getDeclaredMethod("getService", String.class);
                    sGetServiceMethod.setAccessible(true);
                }
                return (IBinder)sGetServiceMethod.invoke(null, name);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                AiLog.w(AndroidHiddenApi.TAG, "Warning : invoke ServiceManager.getService, " + e);
                return null;
            }
        }
    }
}

