/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.build;

import android.os.Parcel;
import android.os.Parcelable;
import com.transsion.aiservice.common.ObjectPoolManager;
import com.transsion.aiservice.common.RecyclerObj;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ParcelablePackage
implements Parcelable,
RecyclerObj {
    public static final int INT_TAG = 100;
    public static final Parcelable.Creator<ParcelablePackage> CREATOR = new Parcelable.Creator<ParcelablePackage>(){

        public ParcelablePackage createFromParcel(Parcel in) {
            ParcelablePackage result = ObjectPoolManager.getInstance().acquire(ParcelablePackage.class);
            result.setParcel(in);
            return result;
        }

        public ParcelablePackage[] newArray(int size) {
            return new ParcelablePackage[size];
        }
    };
    private static final int DATA_TYPE_INT = 1;
    private static final int DATA_TYPE_LONG = 2;
    private static final int DATA_TYPE_STRING = 3;
    private static final int DATA_TYPE_DOUBLE = 4;
    private static final int DATA_TYPE_FLOAT = 5;
    private static final int DATA_TYPE_BYTE_ARRAY = 6;
    private static final int DATA_TYPE_PARCELABLE = 7;
    private static final int DATA_TYPE_PARCELABLE_LIST = 8;
    private static final int DATA_TYPE_PARCELABLE_MAP = 9;
    private final List<DataBean> mData = new ArrayList<DataBean>();
    private Parcel mRawData;

    public static ParcelablePackage obtain() {
        ParcelablePackage result = ObjectPoolManager.getInstance().acquire(ParcelablePackage.class);
        return result;
    }

    public ParcelablePackage build() {
        return this;
    }

    public ParcelablePackage putInt(int value) {
        this.mData.add(new DataBean(1, value));
        return this;
    }

    public ParcelablePackage putString(String value) {
        this.mData.add(new DataBean(3, value));
        return this;
    }

    public ParcelablePackage putFloat(double value) {
        this.mData.add(new DataBean(4, value));
        return this;
    }

    public ParcelablePackage putLong(long value) {
        this.mData.add(new DataBean(2, value));
        return this;
    }

    public ParcelablePackage putByteArray(byte[] value) {
        this.mData.add(new DataBean(6, value));
        return this;
    }

    public ParcelablePackage putParcelable(Parcelable value) {
        this.mData.add(new DataBean(7, value));
        return this;
    }

    @Deprecated
    public ParcelablePackage putParcelableList(List<? extends Parcelable> value) {
        this.mData.add(new DataBean(8, value));
        return this;
    }

    @Deprecated
    public ParcelablePackage putParcelableMap(Map<String, ? extends Parcelable> value) {
        this.mData.add(new DataBean(9, value));
        return this;
    }

    private void setParcel(Parcel in) {
        this.mRawData = in;
        this.mRawData.setDataPosition(0);
    }

    public Parcel getRawData() {
        if (this.mRawData == null) {
            Parcel parcel = Parcel.obtain();
            this.writeToParcel(parcel, 1);
            this.setParcel(parcel);
        }
        return this.mRawData;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.mData.isEmpty()) {
            return;
        }
        for (DataBean dataBean : this.mData) {
            this.insertInParcel(dataBean, dest, flags);
        }
        this.release();
    }

    private void insertInParcel(DataBean dataBean, Parcel dest, int flags) {
        switch (dataBean.type) {
            case 1: {
                dest.writeInt(((Integer)dataBean.mData).intValue());
                break;
            }
            case 3: {
                dest.writeString((String)dataBean.mData);
                break;
            }
            case 2: {
                dest.writeLong(((Long)dataBean.mData).longValue());
                break;
            }
            case 4: {
                dest.writeDouble(((Double)dataBean.mData).doubleValue());
                break;
            }
            case 5: {
                dest.writeFloat(((Float)dataBean.mData).floatValue());
                break;
            }
            case 7: {
                dest.writeParcelable((Parcelable)dataBean.mData, flags);
                break;
            }
            case 6: {
                dest.writeByteArray((byte[])dataBean.mData);
                break;
            }
            case 8: {
                if (!(dataBean.mData instanceof List)) break;
                dest.writeTypedList((List)dataBean.mData);
                break;
            }
            case 9: {
                if (!(dataBean.mData instanceof Map)) break;
                int size = ((Map)dataBean.mData).size();
                Iterator iterator = ((Map)dataBean.mData).entrySet().iterator();
                dest.writeInt(size);
                while (iterator.hasNext()) {
                    Map.Entry item = iterator.next();
                    dest.writeString((String)item.getKey());
                    dest.writeParcelable((Parcelable)item.getValue(), flags);
                }
                break;
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public boolean isRelease() {
        return this.mRawData == null && this.mData.isEmpty();
    }

    @Override
    public void release() {
        this.mData.clear();
        if (this.mRawData != null) {
            this.mRawData.recycle();
        }
        ObjectPoolManager.getInstance().release(this);
    }

    public static class DataBean {
        private final int type;
        private final Object mData;

        public DataBean(int type, Object mData) {
            this.type = type;
            this.mData = mData;
        }
    }
}

