/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.core.channel.local;

import com.transsion.aiservice.common.utils.AiLog;
import com.transsion.aiservice.oxygenbus.core.ProcessAdapter;
import com.transsion.aiservice.oxygenbus.core.RequestHandler;
import com.transsion.aiservice.oxygenbus.core.ResultDataManager;
import com.transsion.aiservice.oxygenbus.core.channel.CallBackTasker;
import com.transsion.aiservice.oxygenbus.core.channel.local.LocalCallBackTasker;
import com.transsion.aiservice.oxygenbus.core.channel.local.LocalChannel;
import com.transsion.aiservice.oxygenbus.core.channel.local.ReturnState;
import com.transsion.aiservice.oxygenbus.core.channel.local.WaiterHandler;
import com.transsion.aiservice.oxygenbus.core.trans.BaseTransData;
import com.transsion.aiservice.oxygenbus.core.trans.CommonTransData;
import com.transsion.aiservice.oxygenbus.datacover.DataParserManager;
import com.transsion.aiservice.oxygenbus.datacover.OxyGenDataPackage;
import com.transsion.aiservice.oxygenbus.service.PluginServiceImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LocalServiceProcess
implements ProcessAdapter<LocalHandler, WaiterHandler> {
    private static final String Tag = "LocalProcess";
    LocalChannel channel = new LocalChannel();
    LocalCallBackTasker localCallBackTasker = new LocalCallBackTasker();
    private final Map<String, LocalHandler> localHandlerMap = new ConcurrentHashMap<String, LocalHandler>(10);

    @Override
    public void initStart() {
    }

    @Override
    public void register(String name, WaiterHandler waiterHandler) {
        if (waiterHandler.isRelease()) {
            return;
        }
        LocalHandler localHandler = this.localHandlerMap.get(name);
        if (localHandler == null) {
            localHandler = new LocalHandler();
            localHandler.setChannel(this.channel);
            this.localHandlerMap.put(name, localHandler);
        }
        try {
            Class clazz = waiterHandler.getServiceClass();
            if (clazz != null) {
                Method method = null;
                method = clazz.getMethod(waiterHandler.getMethodName(), OxyGenDataPackage.class);
                localHandler.addMethod(waiterHandler.getMethodAlias(), new MethodPackage(method, waiterHandler.getFunctionParamType(), waiterHandler.isOneWay()));
                if (localHandler.serverObj == null) {
                    localHandler.serverObj = (PluginServiceImpl)clazz.newInstance();
                    localHandler.serverObj.onConnect();
                }
            } else {
                AiLog.w(Tag, "not find Service class in classLoader");
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            AiLog.w(Tag, "err:" + e);
        }
    }

    @Override
    public RequestHandler getRequestHandler(BaseTransData baseTransData) {
        LocalHandler localHandler = this.localHandlerMap.get(baseTransData.getServiceName());
        if (localHandler == null || !localHandler.have(baseTransData.getFunctionName())) {
            localHandler = this.find(baseTransData);
        }
        return localHandler;
    }

    @Override
    public LocalHandler find(BaseTransData serverAddress) {
        return null;
    }

    @Override
    public void unRegister(String name) {
        LocalHandler handler = this.localHandlerMap.get(name);
        handler.free();
        this.localHandlerMap.remove(name);
    }

    @Override
    public String getAddress(BaseTransData BaseTransData2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(BaseTransData2.getServiceName()).append("_").append(BaseTransData2.getFunctionName());
        return stringBuilder.toString();
    }

    @Override
    public boolean isSupportModule(String moduleName) {
        return this.localHandlerMap.containsKey(moduleName);
    }

    @Override
    public void sendCallBack(Object result) {
    }

    @Override
    public CallBackTasker getCallBackTasker() {
        return this.localCallBackTasker;
    }

    private static class MethodPackage {
        private Method method;
        private final Type mFunctionParamType;
        private boolean isOneWay = false;

        public MethodPackage(Method method, Type functionParamType, boolean isOneWay) {
            this.method = method;
            this.mFunctionParamType = functionParamType;
            this.isOneWay = isOneWay;
        }

        public Type getFunctionParamType() {
            return this.mFunctionParamType;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }
    }

    public static class LocalHandler
    implements RequestHandler {
        private PluginServiceImpl serverObj;
        private LocalChannel channel;
        private final Map<String, MethodPackage> functions = new ConcurrentHashMap<String, MethodPackage>();

        public void addMethod(String methodName, MethodPackage method) {
            this.functions.put(methodName, method);
        }

        @Override
        public LocalChannel getChannel() {
            return this.channel;
        }

        @Override
        public int getFunctionType() {
            return -67108864;
        }

        public void setChannel(LocalChannel channel) {
            this.channel = channel;
        }

        public boolean have(String methodName) {
            return this.functions.containsKey(methodName);
        }

        public void free() {
            this.serverObj = null;
            this.functions.clear();
        }

        @Override
        public Object invoke(String methodName, Object data) {
            return this.handleInvoke(methodName, data);
        }

        private Object handleInvoke(String methodName, Object data) {
            MethodPackage methodPackage = this.functions.get(methodName);
            Object result = null;
            if (methodPackage != null) {
                CommonTransData commonTransData = data instanceof CommonTransData ? (CommonTransData)data : ResultDataManager.getResultData(data);
                try {
                    OxyGenDataPackage paramsObj = this.getParamInTransData(methodPackage, commonTransData);
                    if (commonTransData.getActionType() == 101 || commonTransData.getActionType() == 102) {
                        this.serverObj.onObserverChange(commonTransData);
                    } else {
                        result = methodPackage.method.invoke((Object)this.serverObj, paramsObj);
                    }
                    paramsObj.release();
                    if (methodPackage.isOneWay) {
                        result = ReturnState.ONE_WAY;
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    AiLog.w(LocalServiceProcess.Tag, "err:" + e);
                }
            }
            return result;
        }

        private OxyGenDataPackage getParamInTransData(MethodPackage methodPackage, CommonTransData commonTransData) {
            Object paramsObj = DataParserManager.getInstance().cover(commonTransData, methodPackage.getFunctionParamType());
            return OxyGenDataPackage.create(commonTransData, paramsObj);
        }
    }
}

