/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.core.channel.remote;

import android.app.Application;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import com.transsion.aiservice.common.utils.AiLog;
import com.transsion.aiservice.oxygenbus.core.OxyGenBridge;
import com.transsion.aiservice.oxygenbus.core.ProcessAdapter;
import com.transsion.aiservice.oxygenbus.core.ResultDataManager;
import com.transsion.aiservice.oxygenbus.core.channel.BaseEvent;
import com.transsion.aiservice.oxygenbus.core.channel.remote.RemoteCallBackTasker;
import com.transsion.aiservice.oxygenbus.core.channel.remote.RemoteChannel;
import com.transsion.aiservice.oxygenbus.core.trans.CommonTransData;
import com.transsion.aiservice.oxygenbus.core.trans.IOxyGenAidlInterface;

public class ClientOxyGenAidlInterfaceImpl
extends IOxyGenAidlInterface.Stub {
    private static volatile ClientOxyGenAidlInterfaceImpl sInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientOxyGenAidlInterfaceImpl get() {
        if (sInstance != null) return sInstance;
        Class<ClientOxyGenAidlInterfaceImpl> clazz = ClientOxyGenAidlInterfaceImpl.class;
        synchronized (ClientOxyGenAidlInterfaceImpl.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ClientOxyGenAidlInterfaceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @Override
    public CommonTransData syncRequest(CommonTransData data) throws RemoteException {
        ProcessAdapter processAdapter = OxyGenBridge.getInstance().getAddressProcess(1);
        Object result = null;
        try {
            result = OxyGenBridge.getInstance().request(processAdapter, data);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        return ResultDataManager.getResultData(result);
    }

    @Override
    public IBinder getRemoteServer(int type, String module) throws RemoteException {
        if (type == 302) {
            return RemoteChannel.getCurrentClient().asBinder();
        }
        return null;
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        AiLog.w("===============", "onTransact on:" + Application.getProcessName());
        return super.onTransact(code, data, reply, flags);
    }

    @Override
    public void asyncRequest(CommonTransData data) throws RemoteException {
        if (data.getActionType() == 104 || data.getActionType() == 103) {
            OxyGenBridge.getInstance().getCallBackController().responseToLocal(data);
        } else if (data.getActionType() == 101 || data.getActionType() == 102) {
            OxyGenBridge.getInstance().getCallBackController().onEvent(2, BaseEvent.create(data.getActionType(), data.getRegisterBinder()));
        } else {
            OxyGenBridge.getInstance().getCallBackController().onEvent(2, BaseEvent.create(data.getActionType(), data));
        }
    }

    @Override
    public String getPackageNameFromUid(int uid, int pid) throws RemoteException {
        return RemoteCallBackTasker.getInstance().getPackageNameFromUidInNative(uid, pid);
    }

    @Override
    public String getProcessName() throws RemoteException {
        return "ClientOxyGenAidlInterfaceImpl_" + Application.getProcessName();
    }
}

