/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.core.channel.remote;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import com.transsion.aiservice.common.IInterfaceProxy;
import com.transsion.aiservice.common.ObjectBridge;
import com.transsion.aiservice.common.utils.AiLog;
import com.transsion.aiservice.oxygenbus.OxyGenBus;
import com.transsion.aiservice.oxygenbus.core.ProcessAdapter;
import com.transsion.aiservice.oxygenbus.core.channel.Channel;
import com.transsion.aiservice.oxygenbus.core.channel.remote.AiServiceLocalInterFace;
import com.transsion.aiservice.oxygenbus.core.channel.remote.ClientOxyGenAidlInterfaceImpl;
import com.transsion.aiservice.oxygenbus.core.channel.remote.OxyGenContentProvider;
import com.transsion.aiservice.oxygenbus.core.trans.CommonTransData;
import com.transsion.aiservice.oxygenbus.core.trans.IOxyGenAidlInterface;
import com.transsion.aiservice.oxygenbus.datacover.DataParserManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class RemoteChannel
implements Channel {
    private static final Map<String, IInterfaceProxy<IOxyGenAidlInterface>> PROXY_MAP = new ConcurrentHashMap<String, IInterfaceProxy<IOxyGenAidlInterface>>();

    public static IInterfaceProxy<IOxyGenAidlInterface> getRemoteBinderFromCache(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        return PROXY_MAP.get(key);
    }

    public static void addClientRemoteBinder(String packageName, IOxyGenAidlInterface iOxyGenAidlInterface) {
        IInterfaceProxy<IOxyGenAidlInterface> interfaceProxy = PROXY_MAP.get(packageName);
        if (interfaceProxy == null) {
            interfaceProxy = new IInterfaceProxy<IOxyGenAidlInterface>().bindInterface(iOxyGenAidlInterface);
            PROXY_MAP.put(packageName, interfaceProxy);
        } else {
            interfaceProxy.bindInterface(iOxyGenAidlInterface);
        }
    }

    public static boolean waiteBindService(Intent intent) {
        CountDownLatch mServiceConnected = new CountDownLatch(1);
        RemoteConnection remoteConnection = new RemoteConnection(mServiceConnected);
        if (OxyGenBus.getApplication().bindService(intent, (ServiceConnection)remoteConnection, 1)) {
            try {
                mServiceConnected.await(5000L, TimeUnit.MILLISECONDS);
                return true;
            }
            catch (InterruptedException interruptedException) {}
        } else {
            AiLog.w("RemoteChannel", intent.getComponent().getPackageName() + "bind service failed");
            return false;
        }
        return false;
    }

    public static boolean getBinderInContentProvider(Intent intent) {
        IBinder iBinder = OxyGenContentProvider.Helper.getClientBinder(OxyGenBus.getApplication(), intent.getComponent().getPackageName());
        if (iBinder != null) {
            IInterfaceProxy<IOxyGenAidlInterface> interfaceProxy = new IInterfaceProxy<IOxyGenAidlInterface>().bindInterface(IOxyGenAidlInterface.Stub.asInterface(iBinder));
            PROXY_MAP.put(intent.getComponent().getPackageName(), interfaceProxy);
            return true;
        }
        return false;
    }

    public IInterfaceProxy<IOxyGenAidlInterface> getRemoteBinder(ProcessAdapter processAdapter, CommonTransData transData) {
        IInterfaceProxy<IOxyGenAidlInterface> result = RemoteChannel.getRemoteBinderFromCache(transData.getServiceName());
        if (result != null && result.isConnected()) {
            return result;
        }
        IInterfaceProxy<IOxyGenAidlInterface> aiService = processAdapter.getAiService();
        if (aiService == null || !aiService.isConnected()) {
            AiLog.w("RemoteChannel", "getAiService is null or disConnect");
            return null;
        }
        try {
            IBinder iBinder = aiService.getInterface().getRemoteServer(303, transData.getServiceName());
            if (iBinder != null) {
                result = new IInterfaceProxy<IOxyGenAidlInterface>(IOxyGenAidlInterface.class).bindInterface(IOxyGenAidlInterface.Stub.asInterface(iBinder));
                PROXY_MAP.put(transData.getServiceName(), result);
                return result;
            }
        }
        catch (RemoteException e) {
            AiLog.w("RemoteChannel", "getRemoteBinder err:" + (Object)((Object)e));
        }
        return null;
    }

    public static IOxyGenAidlInterface getCurrentClient() {
        AiServiceLocalInterFace localInterFace = ObjectBridge.get(AiServiceLocalInterFace.class);
        if (localInterFace != null && localInterFace.inAiService()) {
            return localInterFace.getAiService();
        }
        return ClientOxyGenAidlInterfaceImpl.get();
    }

    @Override
    public Object request(ProcessAdapter processAdapter, CommonTransData baseTransData) {
        IInterfaceProxy<IOxyGenAidlInterface> interfaceProxy = this.getRemoteBinder(processAdapter, baseTransData);
        if (interfaceProxy != null && interfaceProxy.isConnected()) {
            return this.actionRequest(baseTransData, interfaceProxy);
        }
        baseTransData.throwClientError("not find Remote Binder");
        return null;
    }

    private Object actionRequest(CommonTransData baseTransData, IInterfaceProxy<IOxyGenAidlInterface> interfaceProxy) {
        try {
            DataParserManager.getInstance().write(baseTransData);
            if (baseTransData.getActionType() == 105) {
                baseTransData.setCallbackHashCode(0);
                baseTransData.setCallBackRequest(false);
                interfaceProxy.getInterface().asyncRequest(baseTransData);
                baseTransData.release();
                return null;
            }
            if (baseTransData.isCallBackRequest()) {
                interfaceProxy.getInterface().asyncRequest(baseTransData);
                baseTransData.release();
                return null;
            }
            return interfaceProxy.getInterface().syncRequest(baseTransData.releaseInParcel());
        }
        catch (RemoteException e) {
            baseTransData.throwClientError((Exception)((Object)e));
            return null;
        }
    }

    private static void cleanDeath() {
        Map<String, IInterfaceProxy<IOxyGenAidlInterface>> temp = new ConcurrentHashMap<String, IInterfaceProxy<IOxyGenAidlInterface>>();
        temp.putAll(PROXY_MAP);
        if (Build.VERSION.SDK_INT >= 24) {
            temp = temp.entrySet().stream().filter(proxyEntry -> ((IInterfaceProxy)proxyEntry.getValue()).isConnected()).collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        PROXY_MAP.clear();
        PROXY_MAP.putAll(temp);
    }

    private static class RemoteConnection
    implements ServiceConnection {
        CountDownLatch countDownLatch;

        public RemoteConnection(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            if (iBinder != null) {
                IInterfaceProxy<IOxyGenAidlInterface> interfaceProxy = new IInterfaceProxy<IOxyGenAidlInterface>().bindInterface(IOxyGenAidlInterface.Stub.asInterface(iBinder));
                PROXY_MAP.put(componentName.getPackageName(), interfaceProxy);
            }
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }
    }
}

