/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.core.channel.remote;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import com.transsion.aiservice.common.IInterfaceProxy;
import com.transsion.aiservice.common.ObjectBridge;
import com.transsion.aiservice.common.utils.AiLog;
import com.transsion.aiservice.oxygenbus.IAiService;
import com.transsion.aiservice.oxygenbus.OxyGenBus;
import com.transsion.aiservice.oxygenbus.core.ProcessAdapter;
import com.transsion.aiservice.oxygenbus.core.RequestHandler;
import com.transsion.aiservice.oxygenbus.core.channel.CallBackTasker;
import com.transsion.aiservice.oxygenbus.core.channel.Channel;
import com.transsion.aiservice.oxygenbus.core.channel.remote.AiServiceLocalInterFace;
import com.transsion.aiservice.oxygenbus.core.channel.remote.ClientOxyGenAidlInterfaceImpl;
import com.transsion.aiservice.oxygenbus.core.channel.remote.RemoteCallBackTasker;
import com.transsion.aiservice.oxygenbus.core.channel.remote.RemoteChannel;
import com.transsion.aiservice.oxygenbus.core.trans.BaseTransData;
import com.transsion.aiservice.oxygenbus.core.trans.IOxyGenAidlInterface;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class RemoteProcess
implements ProcessAdapter<IBinder, String> {
    protected static final String AI_SERVICE_PACKAGE_NAME = "com.transsion.kolun.aiservice";
    private Intent AiServiceIntent = null;
    private CountDownLatch mServiceConnected;
    private final RemoteCallBackTasker mRemoteCallBackTasker = RemoteCallBackTasker.getInstance();
    private final Map<String, RemoteHandler> mProxyMap = new ConcurrentHashMap<String, RemoteHandler>();
    private final AiServiceConnection mAiServiceConnection = new AiServiceConnection();
    protected volatile IInterfaceProxy<IOxyGenAidlInterface> mAiService = new IInterfaceProxy<IOxyGenAidlInterface>(IOxyGenAidlInterface.class);
    RemoteChannel mRemoteChannel;

    @Override
    public void initStart() {
        this.mRemoteChannel = new RemoteChannel();
        this.initAiServiceBinder();
    }

    @Override
    public IInterfaceProxy<IOxyGenAidlInterface> getAiService() {
        if (this.mAiService.isConnected()) {
            return this.mAiService;
        }
        Intent intent = this.getAiServiceIntent();
        intent.setType(OxyGenBus.getApplication().getPackageName());
        if (OxyGenBus.getApplication().bindService(intent, (ServiceConnection)this.mAiServiceConnection, 1)) {
            AiLog.i("RemoteProcess", "waiting for AiService thread =" + Thread.currentThread().getName());
            this.mServiceConnected = new CountDownLatch(1);
            try {
                this.mServiceConnected.await(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mServiceConnected = null;
        }
        return this.mAiService;
    }

    public void setAiService(IInterfaceProxy<IOxyGenAidlInterface> aiService) {
        this.mAiService = aiService;
    }

    protected void initAiServiceBinder() {
        if (this.mAiService.isConnected()) {
            return;
        }
        Intent intent = this.getAiServiceIntent();
        OxyGenBus.getApplication().bindService(intent, (ServiceConnection)this.mAiServiceConnection, 1);
    }

    private Intent getAiServiceIntent() {
        if (this.AiServiceIntent == null) {
            this.AiServiceIntent = new Intent();
            this.AiServiceIntent.setComponent(new ComponentName(AI_SERVICE_PACKAGE_NAME, "com.transsion.kolun.aiservice.service.AiService"));
            Bundle bundle = new Bundle();
            bundle.putBinder("clientBinder", (IBinder)ClientOxyGenAidlInterfaceImpl.get());
            this.AiServiceIntent.putExtra("extra", bundle);
        }
        return this.AiServiceIntent;
    }

    @Override
    public void register(String name, String serverAddress) {
    }

    @Override
    public RequestHandler getRequestHandler(BaseTransData baseTransData) {
        RemoteHandler requestHandler = this.mProxyMap.get(baseTransData.getServiceName());
        if (requestHandler == null) {
            requestHandler = new RemoteHandler(this.mRemoteChannel);
            this.mProxyMap.put(baseTransData.getServiceName(), requestHandler);
        }
        return requestHandler;
    }

    @Override
    public IBinder find(BaseTransData serverAddress) {
        return null;
    }

    @Override
    public void unRegister(String name) {
    }

    @Override
    public String getAddress(BaseTransData baseTransData) {
        return null;
    }

    @Override
    public boolean isSupportModule(String moduleName) {
        AiServiceLocalInterFace interFace = ObjectBridge.get(AiServiceLocalInterFace.class);
        if (interFace == null) {
            return false;
        }
        return interFace.isAiServiceSupportModule(moduleName);
    }

    @Override
    public void sendCallBack(Object result) {
    }

    @Override
    public CallBackTasker getCallBackTasker() {
        return this.mRemoteCallBackTasker;
    }

    private class AiServiceConnection
    implements ServiceConnection {
        private AiServiceConnection() {
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            AiLog.i("RemoteProcess", "AiService ServiceConnected");
            if (iBinder != null) {
                IAiService iAiService = IAiService.Stub.asInterface(iBinder);
                try {
                    IBinder oxygenBinder = iAiService.getBinder(OxyGenBus.getApplication().getPackageName(), 0, "Oxygen");
                    if (oxygenBinder != null) {
                        RemoteProcess.this.mAiService.bindInterface(IOxyGenAidlInterface.Stub.asInterface(oxygenBinder));
                    }
                }
                catch (RemoteException e) {
                    AiLog.i("RemoteProcess", "onServiceConnected err:" + (Object)((Object)e));
                }
            }
            if (RemoteProcess.this.mServiceConnected != null) {
                RemoteProcess.this.mServiceConnected.countDown();
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            AiLog.i("RemoteProcess", "AiService onServiceDisconnected");
            RemoteProcess.this.mAiService.remove();
        }
    }

    public static class RemoteHandler
    implements RequestHandler {
        RemoteChannel remoteChannel = null;

        public RemoteChannel getRemoteChannel() {
            return this.remoteChannel;
        }

        public RemoteHandler(RemoteChannel remoteChannel) {
            this.remoteChannel = remoteChannel;
        }

        @Override
        public Object invoke(String methodName, Object data) {
            return null;
        }

        @Override
        public Channel getChannel() {
            return this.remoteChannel;
        }

        @Override
        public int getFunctionType() {
            return -67108864;
        }
    }
}

