/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.aiservice.oxygenbus.error;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import com.transsion.aiservice.common.WorkerHandler;
import com.transsion.aiservice.common.utils.AiLog;
import com.transsion.aiservice.oxygenbus.core.OxyGenBridge;
import com.transsion.aiservice.oxygenbus.core.ResultDataManager;
import com.transsion.aiservice.oxygenbus.core.channel.BaseEvent;
import com.transsion.aiservice.oxygenbus.core.trans.CommonTransData;
import com.transsion.aiservice.oxygenbus.datacover.OxyGenDataPackage;

public class ExceptionManager {
    private static final String TAG = "ExceptionManager";
    private static volatile ExceptionManager sInstant;
    private final ErrHandler errHandler = new ErrHandler(WorkerHandler.getInstance().createLooper("err_message"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExceptionManager getInstance() {
        if (sInstant != null) return sInstant;
        Class<ExceptionManager> clazz = ExceptionManager.class;
        synchronized (ExceptionManager.class) {
            sInstant = new ExceptionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstant;
        }
    }

    public void setRequestTimeOut(int callbackHashCode, Long timeOver) {
        if (timeOver != 0L) {
            Message message = this.errHandler.obtainMessage();
            if (this.errHandler.hasMessages(callbackHashCode)) {
                this.errHandler.removeMessages(callbackHashCode);
            }
            this.errHandler.sendMessageDelayed(message, timeOver);
        }
    }

    public void removeTimeOutMessage(int callbackHashCode) {
        if (this.errHandler.hasMessages(callbackHashCode)) {
            this.errHandler.removeMessages(callbackHashCode);
        }
    }

    private ExceptionManager() {
    }

    public void postError(CommonTransData commonTransData, Exception e) {
        this.postError(commonTransData, e.getMessage());
    }

    public void postError(CommonTransData commonTransData, String errMessage) {
        AiLog.e(TAG, errMessage);
        this.postError(commonTransData.getClientPackageName(), commonTransData.getServiceType(), commonTransData.getCallbackHashCode(), errMessage);
    }

    public void postError(String clientPackageName, int serviceType, int callbackHashCode, String errMessage) {
        AiLog.e(TAG, errMessage);
        CommonTransData errResult = this.getErrTransData(clientPackageName, serviceType, callbackHashCode, errMessage);
        Message message = this.errHandler.obtainMessage();
        message.obj = errResult;
        this.errHandler.sendMessage(message);
    }

    @NonNull
    private CommonTransData getErrTransData(String clientPackageName, int serviceType, int callbackHashCode, String errMessage) {
        CommonTransData errResult = ResultDataManager.getResultData(errMessage);
        errResult.setActionType(110);
        errResult.setClientPackageName(clientPackageName);
        errResult.setCallbackHashCode(callbackHashCode);
        errResult.setServiceType(serviceType);
        return errResult;
    }

    public static OxyGenDataPackage getErrorDataPackage(String message) {
        return OxyGenDataPackage.create(null, message).setResultCode(202);
    }

    class TimeoutException {
        TimeoutException() {
        }
    }

    class ErrHandler
    extends Handler {
        ErrHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(@NonNull Message msg) {
            if (msg.obj instanceof TimeoutException) {
                ExceptionManager.getInstance().postError("", 1, msg.what, "request time out");
            } else if (msg.obj instanceof CommonTransData) {
                CommonTransData commonTransData = (CommonTransData)msg.obj;
                OxyGenBridge.getInstance().getCallBackController().onEvent(commonTransData.getServiceType(), BaseEvent.create(commonTransData.getActionType(), commonTransData));
            }
            super.handleMessage(msg);
        }
    }
}

