/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.oxygenbus;

import android.os.Environment;
import com.transsion.apiinvoke.monitor.ApiInvokeMonitor;
import com.transsion.apiinvoke.monitor.RecordItem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class KolunRecordMonitor
extends ApiInvokeMonitor.DefaultTraceMonitor {
    private static final String TAG = "ApiInvokeMonitor";
    private static final String MONITOR_FILE_NAME = "monitor_file.log";
    private static volatile KolunRecordMonitor instance;
    private WriteThread mThread = new WriteThread();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KolunRecordMonitor getInstance() {
        if (instance == null) return instance;
        Class<KolunRecordMonitor> clazz = KolunRecordMonitor.class;
        synchronized (KolunRecordMonitor.class) {
            if (instance != null) return instance;
            instance = new KolunRecordMonitor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private KolunRecordMonitor() {
    }

    public void onInvokeStart(RecordItem item) {
        this.mThread.enqueue(item.toString());
    }

    public void onInvokeEnd(RecordItem item) {
    }

    public class WriteThread
    extends Thread {
        private boolean isRunning = false;
        private String filePath = null;
        private Object lock = new Object();
        private ConcurrentLinkedQueue<String> mQueue = new ConcurrentLinkedQueue();

        public WriteThread() {
            String sdcard = this.getPath();
            if (sdcard != null) {
                this.filePath = sdcard + File.separator + KolunRecordMonitor.MONITOR_FILE_NAME;
            }
            this.isRunning = true;
        }

        public String getPath() {
            return this.exist() ? Environment.getExternalStorageDirectory().toString() : null;
        }

        public boolean exist() {
            return Environment.getExternalStorageState().equals("mounted");
        }

        public void enqueue(String str) {
            this.mQueue.add(str);
            if (!this.isRunning()) {
                this.awake();
            }
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void awake() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    this.isRunning = true;
                    while (!this.mQueue.isEmpty()) {
                        try {
                            this.recordStringLog(this.mQueue.poll());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.isRunning = false;
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void recordStringLog(String text) {
            File file = new File(this.filePath);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                FileWriter filerWriter = new FileWriter(file, true);
                BufferedWriter bufWriter = new BufferedWriter(filerWriter);
                bufWriter.write(text);
                bufWriter.newLine();
                bufWriter.close();
                filerWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public boolean isExitLogFile() {
            File file = new File(this.filePath);
            return file.exists() && file.length() > 3L;
        }

        public void deleteLogFile() {
            File file = new File(this.filePath);
            if (file.exists()) {
                file.delete();
            }
        }
    }
}

