/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.oxygenbus.impl;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.transsion.apiinvoke.ipc.APIPublisher;
import com.transsion.apiinvoke.ipc.APISubscribeCenter;
import com.transsion.apiinvoke.ipc.ParcelPublishData;
import com.transsion.apiinvoke.ipc.ParcelPublisher;
import com.transsion.apiinvoke.ipc.SubscribeStateChangeObserver;
import com.transsion.apiinvoke.subscribe.PublishData;
import com.transsion.apiinvoke.subscribe.Publisher;
import com.transsion.kolun.oxygenbus.ISubscribeBusServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SubscribeBusServerImpl
extends ISubscribeBusServer.Stub {
    private static final String TAG = "SubscribeBusServerImpl";
    private static final APISubscribeCenterProxy sApiSubscribeCenter = new APISubscribeCenterProxy();
    private static final Map<SubscribeKey, APIPublisher> GLOBAL_SUBSCRIBE = new ConcurrentHashMap<SubscribeKey, APIPublisher>(8);
    private static volatile SubscribeBusServerImpl instance;
    private Context appContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SubscribeBusServerImpl get(Context appContext) {
        if (instance != null) return instance;
        Class<SubscribeBusServerImpl> clazz = SubscribeBusServerImpl.class;
        synchronized (SubscribeBusServerImpl.class) {
            if (instance != null) return instance;
            instance = new SubscribeBusServerImpl(appContext);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private SubscribeBusServerImpl(Context appContext) {
        this.appContext = appContext;
    }

    @Override
    public APISubscribeCenter getSubscribeCenter() throws RemoteException {
        return sApiSubscribeCenter;
    }

    @Override
    public APIPublisher findSubscribe(String process, String channelName) throws RemoteException {
        return GLOBAL_SUBSCRIBE.get(channelName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSubscribeManager(String process, String subscriber, APIPublisher publisher) throws RemoteException {
        Map<SubscribeKey, APIPublisher> map = GLOBAL_SUBSCRIBE;
        synchronized (map) {
            GLOBAL_SUBSCRIBE.put(new SubscribeKey(subscriber, process), publisher);
        }
    }

    @Override
    public void unRegisterSubscribeManager(String process, String subscriber) throws RemoteException {
        GLOBAL_SUBSCRIBE.remove(new SubscribeKey(subscriber, process));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<APIPublisher> getAPIPublisher(String channel) {
        Map<SubscribeKey, APIPublisher> map = GLOBAL_SUBSCRIBE;
        synchronized (map) {
            ArrayList<APIPublisher> publishers = new ArrayList<APIPublisher>();
            for (Map.Entry<SubscribeKey, APIPublisher> entry : GLOBAL_SUBSCRIBE.entrySet()) {
                SubscribeKey key = entry.getKey();
                if (!key.channel.equals(channel)) continue;
                publishers.add(entry.getValue());
            }
            return publishers;
        }
    }

    private static class SubscribeKey {
        public String channel;
        public String process;

        public SubscribeKey(String channel, String process) {
            this.channel = channel;
            this.process = process;
        }
    }

    private static final class APISubscribeCenterProxy
    extends APISubscribeCenter.Stub {
        private volatile Map<String, Integer> channelSubscribeMap = new ConcurrentHashMap<String, Integer>(16);
        private volatile Map<Publisher, Integer> publishMap = new ConcurrentHashMap<Publisher, Integer>(16);

        private APISubscribeCenterProxy() {
        }

        private boolean notifyObserverChange(ParcelPublisher originData, Publisher publisher, int subscribeCount) {
            try {
                List apiPublishers = SubscribeBusServerImpl.getAPIPublisher(publisher.getChannel());
                if (apiPublishers == null || apiPublishers.size() == 0) {
                    return false;
                }
                for (APIPublisher apiPublisher : apiPublishers) {
                    SubscribeStateChangeObserver observer = apiPublisher.getSubscribeStateChangeObserver();
                    if (observer == null) continue;
                    observer.onSubscribeChange(originData, subscribeCount);
                    return true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return false;
        }

        public int countSubscribe(ParcelPublisher publishData) {
            if (publishData == null) {
                return 0;
            }
            return this.getPublisherCount(publishData.getPublisher());
        }

        public void onPublishData(ParcelPublishData publishData) throws RemoteException {
            PublishData channelPublish = publishData.getPublishData();
            String channel = channelPublish.getPublisher().getChannel();
            try {
                for (Map.Entry entry : GLOBAL_SUBSCRIBE.entrySet()) {
                    APIPublisher manager = (APIPublisher)entry.getValue();
                    if (manager == null) {
                        Log.e((String)SubscribeBusServerImpl.TAG, (String)"onPublishData, channel not registered");
                        return;
                    }
                    manager.onPublishData(publishData);
                    Log.e((String)SubscribeBusServerImpl.TAG, (String)("onPublishData, form " + channel + " to " + entry.getKey()));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSubscribe(ParcelPublisher publisher, String subscribeName, int subscribeCount) throws RemoteException {
            Publisher publish = publisher.getPublisher();
            Map<Publisher, Integer> map = this.publishMap;
            synchronized (map) {
                int count = this.calcCurrentCount(publish, subscribeName, subscribeCount);
                this.publishMap.put(publish, count);
                this.channelSubscribeMap.put(subscribeName, subscribeCount);
                this.notifyObserverChange(publisher, publish, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onUnSubscribe(ParcelPublisher publisher, String subscribeName, int subscribeCount) throws RemoteException {
            Publisher publish = publisher.getPublisher();
            Map<Publisher, Integer> map = this.publishMap;
            synchronized (map) {
                Integer count = this.calcCurrentCount(publish, subscribeName, subscribeCount);
                this.publishMap.put(publish, count);
                this.channelSubscribeMap.put(subscribeName, subscribeCount);
                this.notifyObserverChange(publisher, publish, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int calcCurrentCount(Publisher publish, String subscribeName, int subscribeCount) {
            int count;
            Map<String, Integer> map = this.channelSubscribeMap;
            synchronized (map) {
                int channelCount = this.getChannelSubscribe(subscribeName);
                int nowCount = this.getPublisherCount(publish);
                if (subscribeCount == channelCount) {
                    return Math.max(nowCount, subscribeCount);
                }
                count = nowCount + (subscribeCount - channelCount);
                if (count < 0) {
                    count = 0;
                }
            }
            return count;
        }

        private int getPublisherCount(Publisher publish) {
            Integer count = this.publishMap.get(publish);
            if (count == null) {
                count = 0;
            }
            return count;
        }

        private int getChannelSubscribe(String subscribeName) {
            Integer subscrbies = this.channelSubscribeMap.get(subscribeName);
            if (subscrbies == null) {
                subscrbies = 0;
            }
            return subscrbies;
        }
    }
}

