/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.oxygenbus.kolunevent;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import com.transsion.kolun.common.eventbus.SimpleEventBus;
import com.transsion.kolun.oxygenbus.IOxygenEventBusServer;
import com.transsion.kolun.oxygenbus.OxygenBusService;
import com.transsion.kolun.oxygenbus.kolunevent.IKolunEventBus;

public class SystemEventBus {
    private IKolunEventBusStub kolunEvent = new IKolunEventBusStub();
    private static volatile SystemEventBus instance;
    private static final String CLASS_TYPE = "classType";
    private static final String EVENT_NAME = "eventName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SystemEventBus getInstance() {
        if (instance != null) return instance;
        Class<SystemEventBus> clazz = SystemEventBus.class;
        synchronized (SystemEventBus.class) {
            if (instance != null) return instance;
            instance = new SystemEventBus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SystemEventBus() {
    }

    public <T extends Parcelable> boolean sendSystemEvent(Context context, String observedName, T event) {
        IOxygenEventBusServer eventBusServer = OxygenBusService.getKolunEventBus(context);
        if (eventBusServer != null && event != null) {
            try {
                Bundle bundle = new Bundle();
                bundle.putSerializable(CLASS_TYPE, event.getClass());
                bundle.putParcelable(EVENT_NAME, event);
                eventBusServer.sendEventBus(observedName, bundle);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void registerEventBus(Context appContext) {
        IOxygenEventBusServer kolunEventBus = OxygenBusService.getKolunEventBus(appContext);
        if (kolunEventBus == null) {
            return;
        }
        try {
            kolunEventBus.registerEventBusClient(this.kolunEvent);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private static class IKolunEventBusStub
    extends IKolunEventBus.Stub {
        private IKolunEventBusStub() {
        }

        @Override
        public void sendEvent(String observedName, Bundle bundleEvent) {
            try {
                Class clazz = (Class)bundleEvent.getSerializable(SystemEventBus.CLASS_TYPE);
                Parcelable event = bundleEvent.getParcelable(SystemEventBus.EVENT_NAME);
                SimpleEventBus.getDefault().post(observedName, clazz.cast(event));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

