package com.ts.lib.videocache.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class VideoCacheInfo implements Serializable
{
    private static final long serialVersionUID = 3817171782413324662L;
    /** 视频的url */
    private String mVideoUrl;
    /** 视频类型 */
    private int mVideoType;
    /** 已经缓存的大小，M3U8文件忽略这个变量 */
    private long mCachedSize;
    /** 总大小 */
    private long mTotalSize;
    /** 已经缓存的ts个数 */
    private int mCachedTs;
    /** 总的ts个数 */
    private int mTotalTs;
    /** videourl对应的md5 */
    private String mMd5;
    /** videocacheinfo 存储的目录 */
    private String mSavePath;
    /** 本地代理的端口号，每次可能不一样 */
    private int mLocalPort;
    /** 文件是否缓存完 */
    private boolean mIsCompleted;
    /** 缓存视频的百分比 */
    private float mPercent;
    /** 缓存速度 */
    private float mSpeed;
    /** key表示ts的索引，value表示索引分片的content-length */
    private Map<Integer, Long> mTsLengthMap;
    /** 视频分片的保存结构 */
    private LinkedHashMap<Long, Long> mVideoSegMap;

    /**
     * mVideoSegMap
     * [0, 2], [4,8], [12,20]
     * 一个整视频中有3小段已经下载好了
     * 一定要按照顺序来存储
     *
     * @param url 媒体资源 url
     */
    public VideoCacheInfo(String url)
    {
        mVideoUrl = url;
    }

    public String getVideoUrl()
    {
        return mVideoUrl;
    }

    public void setVideoType(int type)
    {
        mVideoType = type;
    }

    public int getVideoType()
    {
        return mVideoType;
    }

    public void setCachedSize(long cachedSize)
    {
        mCachedSize = cachedSize;
    }

    public long getCachedSize()
    {
        return mCachedSize;
    }

    public void setTotalSize(long totalSize)
    {
        mTotalSize = totalSize;
    }

    public long getTotalSize()
    {
        return mTotalSize;
    }

    public void setCachedTs(int cachedTs)
    {
        mCachedTs = cachedTs;
    }

    public int getCachedTs()
    {
        return mCachedTs;
    }

    public void setTotalTs(int totalTs)
    {
        mTotalTs = totalTs;
    }

    public int getTotalTs() { return mTotalTs; }

    public void setMd5(String md5) { mMd5 = md5; }

    public String getMd5() { return mMd5; }

    public void setSavePath(String savePath) { mSavePath = savePath; }

    public String getSavePath() { return mSavePath; }

    public void setLocalPort(int port) { mLocalPort = port; }

    public int getLocalPort() { return mLocalPort; }

    public void setIsCompleted(boolean isCompleted) { mIsCompleted = isCompleted; }

    public boolean isCompleted() { return mIsCompleted; }

    public void setPercent(float percent) { mPercent = percent; }

    public float getPercent() { return mPercent; }

    public void setSpeed(float speed) { mSpeed = speed; }

    public float getSpeed() { return mSpeed; }

    public void setTsLengthMap(Map<Integer, Long> tsLengthMap)
    {
        mTsLengthMap = tsLengthMap;
    }

    public Map<Integer, Long> getTsLengthMap()
    {
        return mTsLengthMap;
    }

    public void setVideoSegMap(LinkedHashMap<Long, Long> videoSegMap)
    {
        mVideoSegMap = videoSegMap;
    }

    public LinkedHashMap<Long, Long> getVideoSegMap()
    {
        return mVideoSegMap;
    }

    @Override
    public String toString()
    {
        return "VideoCacheInfo{" +
                "mVideoUrl='" + mVideoUrl + '\'' +
                ", mVideoType=" + mVideoType +
                ", mCachedSize=" + mCachedSize +
                ", mTotalSize=" + mTotalSize +
                ", mCachedTs=" + mCachedTs +
                ", mTotalTs=" + mTotalTs +
                ", mMd5='" + mMd5 + '\'' +
                ", mSavePath='" + mSavePath + '\'' +
                ", mLocalPort=" + mLocalPort +
                ", mIsCompleted=" + mIsCompleted +
                ", mPercent=" + mPercent +
                ", mSpeed=" + mSpeed +
                ", mTsLengthMap=" + mTsLengthMap +
                ", mVideoSegMap=" + mVideoSegMap +
                '}';
    }
}
