package com.ts.lib.videocache.model;

import java.util.Objects;

public class VideoRange
{
    /** 分片的起始位置 */
    private long mStart;
    /** 分片的结束位置 */
    private long mEnd;

    public VideoRange(long start, long end)
    {
        mStart = start;
        mEnd = end;
    }

    public long getStart()
    {
        return mStart;
    }

    public long getEnd()
    {
        return mEnd;
    }

    public boolean contains(long position)
    {
        return mStart <= position && position <= mEnd;
    }

    public long getRange()
    {
        return mEnd - mStart;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof VideoRange)) return false;
        VideoRange that = (VideoRange) o;
        return mStart == that.mStart && mEnd == that.mEnd;
    }

    @Override
    public int hashCode()
    {
        return Objects.hash(mStart, mEnd);
    }

    @Override
    public String toString()
    {
        return "VideoRange{" +
                "mStart=" + mStart +
                ", mEnd=" + mEnd +
                '}';
    }
}
