package com.transsion.baseui.dialog

import android.app.Dialog
import android.os.Bundle
import android.view.Gravity
import android.view.WindowManager
import com.blankj.utilcode.util.SizeUtils
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.transsion.baseui.utils.AppUtil

/**
 * Created by gaoxin.liu on 2025/8/14.
 * Description:底部弹框基类
 */
abstract class BaseBottomSheetDialog(private val layoutId: Int): TRBaseDialog() {
    override fun getLayoutId(): Int {
        return layoutId
    }

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        val ctx = requireContext()
        val dialog: Dialog = BottomSheetDialog(ctx, theme)
        dialog.window?.setWindowAnimations(com.transsion.baseui.R.style.BaseBottomDialogAnimation)
        dialog.window?.let {
            it.setGravity(Gravity.BOTTOM)
            it.setDimAmount(0.5f)
            val lp = it.attributes ?: WindowManager.LayoutParams()
            lp.width = AppUtil.getWidth(ctx)
            lp.height = SizeUtils.dp2px(120f)
            it.setBackgroundDrawable(null)
            it.attributes = lp
        }
        return dialog
    }
}