package com.transsion.baseui.dialog

import android.content.Context
import androidx.fragment.app.DialogFragment
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import androidx.fragment.app.FragmentManager
import com.tn.lib.logger.Logger
import com.transsion.base.report.athena.ILogView
import com.transsion.base.report.athena.LogViewConfig

abstract class BaseDialog : DialogFragment, ILogView {

    constructor() : super()
    constructor(contentLayoutId: Int) : super(contentLayoutId)

    override fun show(manager: FragmentManager, tag: String?) {
        try {
            manager.executePendingTransactions()
            if (this.isAdded || manager.findFragmentByTag(tag) != null) {
                return
            }
            Logger.d("show dialog hasShownAnyDialogInSession $this :${DialogSessionManager.hasShownAnyDialogInSession}")
            // 会话限制逻辑
            if (DialogSessionManager.hasShownAnyDialogInSession) {
                // 已有弹窗显示时，仅允许绕过限制的弹窗
                if (!bypassSessionNoLimit()) {
                    return
                }
            } else {
                // 首次弹窗，标记会话状态
                DialogSessionManager.hasShownAnyDialogInSession = true
            }
            onShow()
            super.show(manager, tag)
            BaseDialogManager.showDialog(getPosition())
            // 首次弹窗，标记会话状态
        } catch (e: IllegalStateException) {
            e.printStackTrace()
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
    }

    fun showDialog(context: Context?, tag: String?) {
        if (context is FragmentActivity
            && !context.isFinishing
            && !context.isDestroyed
        ) {
            try {
                showDialog(context.supportFragmentManager, tag)
            } catch (e: IllegalStateException) {
                e.printStackTrace()
            } catch (e: java.lang.Exception) {
                e.printStackTrace()
            }
        }
    }



    fun showDialog(fragment: Fragment, tag: String?) {
        try {
            show(fragment.childFragmentManager, tag)
        } catch (e: IllegalStateException) {
            e.printStackTrace()
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
    }

    private fun showDialog(fragmentManager: FragmentManager, tag: String?) {
        try {
            fragmentManager.executePendingTransactions()
            if (this.isAdded || fragmentManager.findFragmentByTag(tag) != null) {
                return
            }
            show(fragmentManager, tag)
        } catch (e: IllegalStateException) {
            e.printStackTrace()
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
    }

    override val logViewConfig: LogViewConfig? by lazy { newLogViewConfig() }
    override fun onResume() {
        super<DialogFragment>.onResume()
        super<ILogView>.onPageResume()
    }

    override fun onPause() {
        super<DialogFragment>.onPause()
        super<ILogView>.onPagePause()
    }

    override fun onDestroy() {
        super.onDestroy()
        BaseDialogManager.dismissDialog(getPosition())
    }

    open fun getPosition(): String? = null


    // 新增：子类可重写该属性选择是否绕过限制（默认不绕过）
    open fun bypassSessionNoLimit(): Boolean {
        return true
    }

    open fun onShow() {

    }
}