package com.transsion.baseui.dialog


object BaseDialogManager {
    /**
     * 新手引导
     */
    const val POSITION_START = "POSITION_START"

    /**
     * 列变引导
     */
    const val POSITION_FISSION = "POSITION_FISSION"


    /**
     * PalmPay引导
     */
    const val POSITION_PALMPAY = "POSITION_PALMPAY"

    private val dialogPositionList: MutableSet<String> = mutableSetOf()

    fun showDialog(position: String?) {
        position?.let {
            dialogPositionList.add(position)
        }
    }

    fun dismissDialog(position: String?) {
        position?.let {
            dialogPositionList.remove(position)
        }
    }

    fun isShowing(position: String?): Boolean {
        return position?.let {
            dialogPositionList.contains(position)
        } ?: false
    }

}