package com.transsion.baseui.dialog

import android.content.Context
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.view.Gravity
import android.view.WindowManager
import android.widget.FrameLayout
import android.widget.ProgressBar
import androidx.appcompat.app.AppCompatDialog
import com.blankj.utilcode.util.BarUtils
import com.blankj.utilcode.util.ScreenUtils
import com.transsion.baseui.R
import com.transsion.baseui.utils.AppUtil

/**
 *
 * @Description:    简单的全透明loadingDialog
 * @Version:        1.0
 */
class BaseLoadingDialog(context: Context) : AppCompatDialog(context, R.style.BaseTranslucentDialogStyle) {

    private var loadView: ProgressBar? = null
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.base_dialog_loading)
        val frameLayout = findViewById<FrameLayout>(R.id.fl)
        loadView = findViewById<ProgressBar>(R.id.load_view)
        //loadView?.indeterminateTintList = ColorUtils.getColor(R.color.cl01ss)
        val w = AppUtil.dp2px(context, 28f).toInt()
        val layoutParams = FrameLayout.LayoutParams(w, w)
        layoutParams.gravity = Gravity.TOP or Gravity.CENTER_HORIZONTAL
        layoutParams.topMargin = ScreenUtils.getAppScreenHeight() / 2 - BarUtils.getStatusBarHeight() - AppUtil.dp2px(context, 54f).toInt()
        //frameLayout?.addView(loadView, layoutParams)
        window?.apply {
            setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
            setGravity(Gravity.CENTER)
            setWindowAnimations(0)
            //全透明
            setBackgroundDrawableResource(com.transsion.base.widgets.R.color.transparent)
            setDimAmount(0f)
            //设置弹出dialog的时候，和 Activity 展示的状态栏是一样的
            clearFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND)
//            setWindowAnimations(0)
            val param = attributes
            param.width = ScreenUtils.getScreenWidth()
            param.height = ScreenUtils.getAppScreenHeight()
            attributes = param
        }
    }

    override fun show() {
        super.show()
        loadView?.visible()
    }

    override fun dismiss() {
        super.dismiss()
        loadView?.gone()
    }

    override fun cancel() {
        super.cancel()
        loadView?.gone()
    }
}